/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Durations;
import com.complexible.common.base.Options;
import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.QueryManager;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ExplainOptions;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.cli.ParameterizedQueryCommand;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.inject.Inject;
import com.stardog.stark.Namespace;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Command(name="explain", description="Returns an execution plan for the given query.", discussion="Given a query, this command returns the optimized execution plan for the query against a database. The <query> can be provided as query string, the name of a stored query or the ID of a running query. If the connection uses reasoning, the resulting plan will take that into account.", examples={"* Return an execution plan for the specified query against the db 'myDb':", "    $ stardog query explain myDb \"SELECT ?title WHERE { <http://example.org/book/book1> <http://purl.org/dc/elements/1.1/title> ?title . }\""})
public final class ExplainQuery
extends ParameterizedQueryCommand<Void> {
    @Option(name={"--profile"}, description="Enable query profiling to measure runtime and memory footprint of query operators")
    public boolean mProfile = false;
    @Option(description="Timeout for the query in ms. An optional time unit can be specified by the suffix 'h' (for hours), 'm' (for minutes), or 's' (for seconds). Timeout value of 0 results in no timeout. Only applicable for use with the --profile option.", name={"--timeout"}, title="N[h|m|s]")
    public String mTimeout = null;
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");

    @Inject
    public ExplainQuery(PasswordReader theReader) {
        super(theReader);
        this.mDbName = null;
        this.mQuery = null;
        this.mIsFile = false;
        this.mFile = null;
    }

    private void printExplain(String query, String explain) {
        System.out.println(ExplainQuery.get("explain.msg.exec", query));
        System.out.println();
        System.out.println(ExplainQuery.get("explain.msg.result", new Object[0]));
        System.out.println(explain);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        Query<?> aQuery;
        Supplier<Iterable<Namespace>> aNamespaces = () -> CliUtil.namespaces(theConn);
        Function<String, Query<?>> aQueryFactory = q -> CliUtil.query(q, theConn);
        if (this.isQueryID(this.mQuery)) {
            QueryManager m = theConn.admin().getQueryManager();
            QueryInfo qi = m.getQuery(this.mQuery, this.mVerbose);
            Optional plan = qi.getRenderedPlan();
            if (plan.isPresent()) {
                this.printExplain(qi.toString(), (String)plan.get());
                return;
            }
            String aQueryStr = qi.getQuery();
            aQuery = this.createQuery(aQueryStr, aQueryFactory, aNamespaces);
        } else {
            aQuery = this.readQuery(aQueryFactory, aNamespaces);
            if (this.mProfile && this.mTimeout != null) {
                long aTimeout = Durations.parse((String)this.mTimeout);
                aQuery.timeout(aTimeout);
            }
        }
        this.printExplain(aQuery.toString(), aQuery.explain(Options.of((com.complexible.common.base.Option)ExplainOptions.VERBOSE, (Object)this.mVerbose, (com.complexible.common.base.Option)ExplainOptions.PROFILE, (Object)this.mProfile)));
    }

    private boolean isQueryID(String theQueryID) {
        if (theQueryID == null) {
            return false;
        }
        try {
            Integer.parseInt(theQueryID);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Matcher m = UUID_PATTERN.matcher(theQueryID);
            return m.matches();
        }
    }
}

