/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;

@Command(name="drop", description="Drops an existing database.", discussion="Deletes an existing database. Once removed, the database will no longer be available to users and all extant data on disk will be removed.", examples={"* Drop the database named 'foo':", "    $ stardog-admin db drop foo"})
public final class Delete
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="Database to drop.", required=true, title={"database"})
    public String mDbName;

    @Inject
    public Delete(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String aName = this.mDbName;
        if (aName == null || aName.trim().equals("")) {
            System.out.println(Delete.get("delete.error.noname", new Object[0]));
            return;
        }
        theConn.drop(aName);
        System.out.println(Delete.get("delete.msg.success", aName));
    }
}

