/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.cli.impl.ReasonableConnectionCommand;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.stardog.model.DataModelFormat;
import com.stardog.model.DataModelGeneratorOptions;
import com.stardog.model.DataModelOwlWriter;
import com.stardog.model.DataModelWriter;
import com.stardog.model.DataModelWriterOptions;
import com.stardog.model.DataModelWriters;
import com.stardog.stark.Namespace;
import com.stardog.stark.io.RDFFormat;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.util.List;

@Command(name="model", description="Generates a data model from the specified input and outputs the model in the desired format.", examples={"* Generate a data model from the RDFS/OWL schema into a GraphQL schema:", "    $ stardog data model --input OWL --output GraphQL myDb > schema.graphqls", "", "* Convert the SHACL schema into SQL table mappings that can be used by Stardog's BI/SQL server:", "    $ stardog data model --input SHACL --output SQL myDb > tableMappings.ttl", ""})
public final class DataModel
extends ReasonableConnectionCommand<Void> {
    @Option(name={"--input"}, title="input", description="The input source that will be used to generate the data model. Valid values are [OWL, SHACL, VIRTUAL]. Default is OWL.")
    public String mInput = DataModelFormat.OWL.getName();
    @Option(name={"--output"}, title="output", description="The output format for serializing the data model. Valid values are [GraphQL, OWL, SHACL, SQL, TEXT]. Default is TEXT.")
    public String mOutput = DataModelFormat.TEXT.getName();
    @Option(name={"-f", "--format"}, description="RDF format for outputs that are serialized in RDF. Allowed RDF formats are [NTRIPLES, RDF/XML, TURTLE, PRETTY_TURTLE, TRIG, N3, NQUADS, JSONLD].", title="RDF Format")
    public String mFormat;
    @Option(name={"--include-provenance"}, description="Whether to include provenance metadata with the model.", title="include provenance")
    public boolean mIncludeProvenance = false;
    @Option(name={"--input-limit"}, description="(Applicable to OWL input without reasoning) Limit the number of triples that will be read from the input graphs to generate the data model. If there are more triples in the input graphs the data model generation will fail.", title="N")
    public int mLimit = -1;
    @Option(name={"-g", "--graph"}, arity=0x7FFFFFFF, title="named graph(s)", description="(Applicable to OWL input without reasoning) The named graphs from which the data model will be generated. By default all the named graphs with schema information will be used.")
    public List<String> mNamedGraphs = Lists.newArrayList();
    @Option(name={"--rdfs-domain-range"}, description="(Applicable to OWL output) Use RDFS domain and range properties instead of schema.org domainIncludes and rangeIncludes properties.", arity=0)
    public boolean mRrdfsDomainRange = false;
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https.", title={"database"})
    public String mDbName;

    @Inject
    public DataModel(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        DataModelFormat aInputFormat = DataModelFormat.forName((String)this.mInput);
        DataModelFormat aOutputFormat = DataModelFormat.forName((String)this.mOutput);
        if (this.mIncludeProvenance && aOutputFormat != DataModelFormat.SHACL) {
            throw new IllegalArgumentException("Output format SHACL required with option --include-provenance.");
        }
        DataModelWriter aWriter = (DataModelWriter)DataModelWriters.getWriter((DataModelFormat)aOutputFormat).orElseThrow(() -> new IllegalArgumentException("Cannot write schema in " + String.valueOf(aOutputFormat) + " format"));
        Options aInputOptions = Options.create().set(DataModelGeneratorOptions.INCLUDE_PROVENANCE_VIRTUAL, (Object)this.mIncludeProvenance);
        if (this.mLimit > 0) {
            aInputOptions.set(DataModelGeneratorOptions.INPUT_SIZE_LIMIT, (Object)this.mLimit);
        }
        if (!this.mNamedGraphs.isEmpty()) {
            aInputOptions.set(DataModelGeneratorOptions.INPUT_GRAPHS, CliUtil.readIRIs(this.mNamedGraphs, (Iterable<Namespace>)theConn.namespaces()));
        }
        com.stardog.model.DataModel aModel = theConn.generateModel(aInputFormat, aInputOptions);
        Options aOutputOptions = Options.create().set(DataModelWriterOptions.NAMESPACES, (Object)theConn.namespaces());
        if (this.mFormat != null) {
            RDFFormat aFormat = CliUtil.getFormat(this.mFormat);
            aOutputOptions.set(DataModelWriterOptions.SERIALIZATION_FORMAT, (Object)aFormat).set(DataModelOwlWriter.USE_SCHEMA_ORG, (Object)(!this.mRrdfsDomainRange ? 1 : 0));
        }
        aWriter.write((OutputStream)System.out, aModel, aOutputOptions);
    }

    @Override
    protected String connectionString() {
        return this.mDbName;
    }
}

