/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.DatabaseBuilder;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.index.IndexOptions;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.MetadataIO;
import com.google.inject.Inject;
import com.stardog.stark.Resource;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

@Command(name="create", description="Creates a new database.", discussion="The new database will be persisted to the Stardog home directory and set online. Files to be added to the database may be passed as final arguments. If a directory is passed as one of the final arguments, all the files in that directory and its child directories will be recursively loaded to the database. Additionally, zip files will be uncompressed and the RDF files they contain will be loaded. Files with unrecognized extensions, or that produce parse errors, will be (silently) ignored. Named graphs can be specified with an @ sign preceding the graph iri. All files after that graph will be loaded into that graph until another @graph is encountered. A single @ can be used to switch back to the default graph. By default, files are not copied to the remote server; only the paths are sent.  If the files do not exist on the remote server, the '--copy-server-side' flag should be specified in order to copy them before creating the database and bulk loading the information.", examples={"* Create a new database with the default options by providing a name and a set of initial datasets to load:", "    $ stardog-admin db create -n my-database input.ttl another_file.rdf moredata.rdf.gz", "", "* Create an empty database from a configuration file:", "    $ stardog-admin db create -c database.properties", "", "* Create a database with initial input to be bulk loaded and some other options:", "    $ stardog-admin db create -n db1 -o icv.enabled=true icv.reasoning.enabled=true -- input.ttl", "", "* Create a database loading separate files into separate named graphs:", "    $ stardog-admin db create -n myDb input0.ttl @http://stardog.com/graph/1 input1.ttl input2.ttl @urn:stardog:graph:2 input3.ttl @ input4.ttl", ""})
public final class Create
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--copy-server-side"}, title="Copy Server Side", description="Flag to specify whether or not files to be bulk loaded should be copied to the remote machine. By default, files are not copied, only the specified paths are sent to the machine with the expectation that they exist on the server.  So to transfer the files to be bulk loaded, you must specify this option.")
    public boolean mCopyServerSide;
    @Option(name={"-c", "--config"}, title="config", description="Database configuration file. This file specifies the name and options to use when creating the database. Options specified explicitly on the command line override those in the configuration file.")
    public String mConfigFile;
    @Option(name={"-o", "--options"}, title="options", arity=0x7FFFFFFF, description="Database configuration options. Each option is a 'key=value' pair; multiple options are separated by whitespaces, e.g., '-o \"option1=value1 option2=value2\"'. When used as the last option, values should be followed by '--'.")
    public List<String> mDbOptions;
    @Option(name={"-n", "--name"}, title="name", description="Database name. The first letter must be an alpha character. Subsequent characters may be alphanumeric, underscore, or dash. The name is a required property of a database, but it can be omitted on the command line if it is specified in a configuration file via the -c/--config flag.")
    public String mSourceDb;
    @Arguments(title={"file"}, description="The list of files to bulk load into the database when it is created, and, optionally, the named graph(s) into which to load them.")
    public List<String> mFiles;

    @Inject
    public Create(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        String aName;
        boolean mHasOptions;
        boolean aHasConfigFile;
        Metadata aOptions = Metadata.create();
        boolean bl = aHasConfigFile = this.mConfigFile != null && !this.mConfigFile.isEmpty();
        if (aHasConfigFile) {
            try (InputStream propsFileStream = Files.newInputStream(Paths.get(this.mConfigFile, new String[0]), new OpenOption[0]);){
                MetadataIO.readProperties((Metadata)aOptions, (InputStream)propsFileStream);
            }
            catch (FileNotFoundException e) {
                throw new CliException(Create.get("create.config.file.missing", this.mConfigFile));
            }
            catch (IOException e) {
                throw new CliException(Create.get("create.config.file.error", this.mConfigFile));
            }
        }
        boolean bl2 = mHasOptions = this.mDbOptions != null && !this.mDbOptions.isEmpty();
        if (mHasOptions) {
            for (String aOptionStr : this.mDbOptions) {
                String[] aKeyValuePair = aOptionStr.trim().split("=");
                if (aKeyValuePair.length != 2) {
                    throw new CliException(Create.get("create.config.option.invalid", aOptionStr));
                }
                boolean aOptionSet = MetadataIO.read((Metadata)aOptions, (String)aKeyValuePair[0].trim(), (String)aKeyValuePair[1].trim());
                if (aOptionSet) continue;
                throw new CliException(Create.get("create.config.option.invalid", aOptionStr));
            }
        }
        if (this.mSourceDb != null && !this.mSourceDb.isEmpty()) {
            aOptions.set((MetaProperty)DatabaseOptions.NAME, (Object)this.mSourceDb);
            aName = this.mSourceDb;
        } else {
            aName = (String)aOptions.get((MetaProperty)DatabaseOptions.NAME);
        }
        if (aName == null) {
            throw new CliException(Create.get("create.error.name.missing", new Object[0]));
        }
        DatabaseBuilder aBuilder = theConn.newDatabase(aName).setAll(aOptions).reporter(System.out);
        if (this.mCopyServerSide) {
            aBuilder.copyServerSide();
        }
        aBuilder.set(IndexOptions.PERSIST, (Object)true);
        Map<Path, Resource> aFiles = CliUtil.getFilesAndGraphs(this.mFiles);
        if (aFiles != null) {
            aBuilder.create(aFiles::get, aFiles.keySet().toArray(new Path[0]));
        } else {
            aBuilder.create(new Path[0]);
        }
    }
}

