/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.OptionalSecureStardogAdminCommand;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metrics.MetricOptions;
import com.complexible.stardog.util.report.DiagnosticsReport;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="report", description="Gathers information for bug reports", examples={"* Gather up information from the system and create a zip file that can be used for debugging.", "    $ stardog-admin diagnostics report", "", "* Do a dry run and include the properties file for <myDB>.", "    $ stardog-admin diagnostics report -n -i $STARDOG_HOME/<myDB>/index.metadata", "", "* Exclude stardog.log and create a file with a specific file name in $STARDOG_HOME", "    $ stardog-admin diagnostics report -x $STARDOG_HOME/stardog.log -o $STARDOG_HOME/filesForStardog.zip", "", "* Retrieve the report from a remote server.", "    $ stardog-admin --server http://example.xom:5820 diagnostics report --remote", ""})
public class CrashReport
extends OptionalSecureStardogAdminCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrashReport.class);
    @Option(name={"-o", "--output"}, title="outputFile", description="The path to the report output file. By default, the command will create a file called stardog-report_YYYY-MM-DD_hh-mm-ss.zip in your current directory. When using this parameter, you must specify a full file path.")
    public String mName;
    @Option(name={"-i", "--include"}, title="fileToInclude", description="This option allows you to include a list of additional specific files. By default, the command includes any .log files in $STARDOG_HOME, including stardog.log, zookeeper.log and starrocks.log, as well as audit.log and access.log if have them. It will also include stardog.properties. In some cases the default set (which can be seen with the --dry-run option) will not include all the needed information for a specific system. If you know of something relevant within $STARDOG_HOME that should be included in the zip file, this option can be used to include it. This option can be specified multiple times.")
    public List<String> mIncludes;
    @Option(name={"-x", "--exclude"}, title="fileToExclude", description="This option allows you to exclude files from the report. It can be handy if you have secrets in your stardog.properties file. It can be specified multiple times.")
    public List<String> mExcludes;
    @Option(name={"-d", "--databases"}, description="Include everything under STARDOG_HOME in the report")
    public boolean mStardogHome = false;
    @Option(name={"-s", "--no-system"}, description="This switch prevents system data like /var/log/kern.log from being included in the report. For a complete list of what is included in the report file use the --dry-run option.")
    public boolean mNoSystem = false;
    @Option(name={"-n", "--dry-run"}, description="This option will scan your system for relevant data but not actually create a zip file. It is useful for trying to audit what files will be copied into the final report. ")
    public boolean mDryRun = false;
    @Option(name={"--remote"}, description="This option will cause this command to connect to a server and retrieve the diagnostics report from the server. The configuration option 'diagnostics.allowIP' should be set in the stardog.properties to specify the IP address of the machine from which this command can be executed. By default, this option is set to 127.0.0.1 so the Stardog server will not allow remote clients to execute this command.  When --remote is not supplied, the command will collect the information from the local file system.")
    public boolean mRemote = false;

    @Inject
    public CrashReport(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws Exception {
        File aFile;
        DiagnosticsReport aDiagnosticsReport = new DiagnosticsReport(this.mIncludes, this.mExcludes, this.mStardogHome, this.mNoSystem, this.mDryRun);
        String aServerURL = this.getServerURL(this.mServerURL);
        if (aServerURL != null && !aServerURL.contains("localhost") && !aServerURL.contains("127.0.0.1")) {
            this.mRemote = true;
        }
        if (this.mRemote && theConn == null) {
            throw new CliException("Remote server is not accessible at " + this.getServerURL(this.mServerURL) + ", check your connection parameters or run this command on the server machine without the --remote option.");
        }
        if (!this.mRemote && theConn != null) {
            aDiagnosticsReport.setMetrics(theConn.currentStatus(Options.of((com.complexible.common.base.Option)MetricOptions.THREADS, (Object)true)));
            Map aDbConfigs = theConn.list().stream().collect(Collectors.toMap(Function.identity(), db -> theConn.get(db, MetaProperties.allProperties())));
            aDiagnosticsReport.setDbConfigs(aDbConfigs);
        }
        File file = aFile = this.mRemote ? theConn.generateDiagnosticReport(aDiagnosticsReport) : aDiagnosticsReport.createZip();
        if (this.mName == null) {
            SimpleDateFormat aSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            this.mName = "stardog-report_" + aSimpleDateFormat.format(new Date()) + ".zip";
        }
        if (!this.mDryRun) {
            Path aTestFile = Paths.get(this.mName, new String[0]);
            if (Files.exists(aTestFile, new LinkOption[0])) {
                Files.move(aTestFile, Paths.get(this.mName + ".old", new String[0]), new CopyOption[0]);
            }
            Files.move(aFile.toPath(), aTestFile, new CopyOption[0]);
        }
        for (String fileName : aDiagnosticsReport.getAddedSourceFiles()) {
            System.out.println("Adding " + fileName);
        }
        for (String fileName : aDiagnosticsReport.getFailedSourceFiles()) {
            System.err.println("Failed to add the file " + fileName);
        }
        if (this.mStardogHome && !aDiagnosticsReport.isGotHome()) {
            System.out.println("Stardog appears to be running because the home is locked. We cannot copy the databases while it is running so we are skipping them. Please stop the Stardog server and re-run this command.");
        }
        if (!this.mDryRun) {
            System.out.println("Created the file: " + this.mName);
        }
    }
}

