/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Strings2;
import com.complexible.common.timer.DurationFormat;
import com.complexible.stardog.Schemas;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.impl.AbstractConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.BaseStardogCommand;
import com.complexible.stardog.security.StardogAuthenticationException;
import com.complexible.stardog.security.StardogAuthorizationException;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionCommand<T>
extends BaseStardogCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionCommand.class);
    private boolean mLocalhost = false;

    public ConnectionCommand(PasswordReader theReader) {
        super(theReader);
    }

    protected String getReasoningSchema() {
        return Schemas.NULL;
    }

    protected boolean isExactSize() {
        return false;
    }

    protected boolean isLocalhost() {
        return this.mLocalhost;
    }

    protected UUID getTxId() {
        return null;
    }

    @Override
    public T call() throws Exception {
        this.validateOptionPatterns();
        String aStr = this.connectionString();
        try {
            this.execute(this.configureConnection(aStr));
        }
        catch (CliException e) {
            throw e;
        }
        catch (StardogAuthenticationException e) {
            throw new CliException(ConnectionCommand.get("auth.failed", new Object[0]));
        }
        catch (StardogAuthorizationException e) {
            throw new CliException(ConnectionCommand.get("auth.permission.denied", new Object[0]));
        }
        catch (StardogException e) {
            throw new CliException(e);
        }
        return null;
    }

    protected void execute(ConnectionConfiguration config) {
        try (Connection aConn = config.connect();){
            this.execute(aConn);
        }
    }

    protected ConnectionConfiguration configureConnection(String aStr) {
        if (aStr == null) {
            throw new CliException(ConnectionCommand.get("cmd.error.noconn", "The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https."));
        }
        if (((String)aStr).startsWith("\"") || ((String)aStr).startsWith("'")) {
            aStr = ((String)aStr).substring(1);
        }
        if (((String)aStr).endsWith("\"") || ((String)aStr).endsWith("'")) {
            aStr = Strings2.withoutLastCharacter((String)aStr);
        }
        aStr = !((String)aStr).contains("://") ? this.getServerURL(null) + "/" + (String)aStr : this.getServerURL((String)aStr);
        try {
            this.mLocalhost = URI.create((String)aStr).getHost().equals("localhost");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConnectionConfiguration aConf = ConnectionConfiguration.from((String)aStr).schema(this.getReasoningSchema());
        aConf.exactSize(this.isExactSize());
        aConf.setAll(this.getConnectionOptions((String)aConf.get(ConnectionConfiguration.SERVER), (String)aConf.get(ConnectionConfiguration.DATABASE)));
        aConf.set(ConnectionConfiguration.TX, (Object)this.getTxId());
        if (this.mRunAs != null) {
            aConf.runningAs(this.mRunAs);
        }
        return aConf;
    }

    protected void closeQuietly(Connection theConn) {
        try {
            if (theConn != null) {
                theConn.close();
            }
        }
        catch (StardogException e) {
            LOGGER.warn("Ignored error while closing connection", (Throwable)e);
        }
    }

    protected static void closeWithoutRollback(Connection theConn) {
        ((AbstractConnection)theConn).close(false);
    }

    protected static void commitAndClose(Connection theConn, long theStartTime, boolean isCommit) {
        if (isCommit) {
            theConn.commit();
            long aTime = System.currentTimeMillis() - theStartTime;
            System.out.println(ConnectionCommand.get("tx.commit.success", DurationFormat.LONG.format(aTime)));
        } else {
            ConnectionCommand.closeWithoutRollback(theConn);
            System.out.println(ConnectionCommand.get("tx.update.success", new Object[0]));
        }
    }

    public abstract void execute(Connection var1) throws StardogException;

    protected abstract String connectionString();
}

