/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.FormattingResourceBundle;
import com.complexible.common.base.Options;
import com.complexible.common.base.Strings2;
import com.complexible.common.io.Files2;
import com.complexible.common.rdf.query.SPARQLUtil;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.StoredQuery;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.Metadata;
import com.complexible.stardog.metadata.MetadataIO;
import com.complexible.stardog.security.StardogAuthorizationException;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.RDFWriters;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class CliUtil {
    private static final FormattingResourceBundle mResourceBundle = new FormattingResourceBundle("com.complexible.stardog.cli.impl.CLI");

    private CliUtil() {
        throw new AssertionError();
    }

    public static RDFFormat getFormat(String theFormat) {
        return RDFFormats.forName((String)theFormat).orElse(null);
    }

    public static RDFFormat getFormat(String theFormatName, File theFile) {
        RDFFormat aFormat = null;
        if (!Strings.isNullOrEmpty((String)theFormatName)) {
            aFormat = CliUtil.getFormat(theFormatName);
            if (aFormat == null) {
                throw new IllegalArgumentException(theFormatName);
            }
        } else if (theFile != null && (aFormat = RDFFormats.forFile((String)theFile.getName(), null)) == null) {
            throw new IllegalArgumentException("'" + com.google.common.io.Files.getFileExtension((String)theFile.getName()) + "' is not a known RDF format file extension.");
        }
        return aFormat;
    }

    protected static char[] readPassword(PasswordReader thePWReader, String thePrompt) throws CliException {
        if (thePWReader == null || !thePWReader.canRead()) {
            throw new CliException(mResourceBundle.get("auth.no.console.no.password", new Object[0]));
        }
        try {
            return thePWReader.readPassword(thePrompt, new Object[0]);
        }
        catch (IOException e) {
            throw new CliException(mResourceBundle.get("auth.password.cannot.read", new Object[0]));
        }
    }

    protected static Metadata readOptions(Iterable<String> mOptions) {
        Metadata metadata = Metadata.create();
        CliUtil.readOptions(mOptions, metadata);
        return metadata;
    }

    protected static void readOptions(Iterable<String> mOptions, Metadata aOptions) {
        Map<String, String> aNvPairs = CliUtil.readNameValuePairs(mOptions);
        for (Map.Entry<String, String> entry : aNvPairs.entrySet()) {
            if (!MetaProperties.contains((String)entry.getKey())) {
                throw new CliException(String.format("Invalid option: %s.", entry.getKey()));
            }
            boolean aOptionSet = MetadataIO.read((Metadata)aOptions, (String)entry.getKey(), (String)entry.getValue());
            if (aOptionSet) continue;
            throw new CliException(String.format("Invalid option value for %s: %s.", entry.getKey(), entry.getValue()));
        }
    }

    protected static Map<String, String> readNameValuePairs(Iterable<String> mOptions) {
        HashMap<String, String> aNvPairs = new HashMap<String, String>();
        for (String aKeyValue : mOptions) {
            for (String aOption : mOptions) {
                String[] aKeyValuePair = aOption.split("=", 2);
                if (aKeyValuePair.length != 2) {
                    throw new CliException(String.format("Invalid option argument: %s.", aKeyValue));
                }
                aNvPairs.put(aKeyValuePair[0], aKeyValuePair[1]);
            }
        }
        return aNvPairs;
    }

    public static String cleanQuery(String theQueryStr) {
        String aQueryStr = theQueryStr;
        aQueryStr = aQueryStr.trim();
        aQueryStr = Strings2.withoutQuotes((String)aQueryStr);
        aQueryStr = aQueryStr.trim();
        return aQueryStr;
    }

    public static IRI readIRI(String theInput, Iterable<Namespace> theNamespaces) {
        return CliUtil.readIRIs(Collections.singleton(theInput), theNamespaces).iterator().next();
    }

    public static Set<IRI> readIRIs(Iterable<String> theInput, Iterable<Namespace> theNamespaces) {
        NamespacesImpl aNamespaces = new NamespacesImpl(theNamespaces);
        HashSet aResult = Sets.newHashSet();
        for (String aStr : theInput) {
            try {
                aResult.add(Values.iri((String)aNamespaces.map(aStr).orElse(aStr)));
            }
            catch (Exception e) {
                throw new CliException("Invalid IRI: " + aStr + "\n" + e.getMessage());
            }
        }
        return aResult;
    }

    public static Set<Statement> readGraph(String theInput, String theFormatName, Iterable<Namespace> theNamespaces) throws InvalidRDF, IOException {
        if (theInput == null) {
            return null;
        }
        Path aFile = Paths.get(theInput, new String[0]);
        if (Files.exists(aFile, new LinkOption[0])) {
            RDFFormat aFormat = CliUtil.getFormat(theFormatName, aFile.toFile());
            return RDFParsers.read((InputStream)Files.newInputStream(aFile, new OpenOption[0]), (RDFFormat)aFormat);
        }
        RDFFormat aFormat = CliUtil.getFormat(theFormatName, null);
        if (aFormat == null) {
            aFormat = RDFFormats.TURTLE;
        }
        if (aFormat.equals((Object)RDFFormats.TURTLE) || aFormat.equals((Object)RDFFormats.TRIG)) {
            StringBuilder sb = new StringBuilder();
            for (Namespace aNS : theNamespaces) {
                sb.append("@prefix ").append(aNS.prefix()).append(": <").append(aNS.iri()).append(">.\n");
            }
            sb.append(theInput.trim());
            if (sb.charAt(sb.length() - 1) != '.') {
                sb.append('.');
            }
            theInput = sb.toString();
        }
        return RDFParsers.read((InputStream)new ByteArrayInputStream(theInput.getBytes()), (RDFFormat)aFormat, (Options)ParserOptions.baseIRI((String)aFile.toUri().toString()));
    }

    public static long writeGraph(Iterable<Statement> theStmts, RDFFormat theFormat, Iterable<Namespace> theNamespaces, OutputStream theOutput) throws StardogException {
        return RDFWriters.write((OutputStream)theOutput, (RDFFormat)theFormat, theStmts, (Iterable)new NamespacesImpl(theNamespaces));
    }

    public static long writeGraph(Iterator<Statement> theStmts, RDFFormat theFormat, Iterable<Namespace> theNamespaces, OutputStream theOutput) throws StardogException {
        return RDFWriters.write((OutputStream)theOutput, (RDFFormat)theFormat, () -> theStmts, (Iterable)new NamespacesImpl(theNamespaces));
    }

    public static Namespaces namespaces(Connection theConn) throws StardogException {
        Namespaces aNamespaces = Namespaces.DEFAULT;
        try {
            aNamespaces = theConn.namespaces();
        }
        catch (StardogAuthorizationException e) {
            System.out.println("Could not retrieve namespaces from database, proceeding without them.");
        }
        return aNamespaces;
    }

    public static String storedQueryString(String query, Connection theConn) throws StardogException {
        String storedQueryString = query;
        if (StoredQuery.isValidName((String)query)) {
            try {
                storedQueryString = theConn.admin().getStoredQueries().get(query).getQuery();
            }
            catch (Exception e) {
                throw new StardogException("Stored query not found: " + query);
            }
        }
        return storedQueryString;
    }

    public static Query<?> query(String aQueryStr, Connection theConn) throws StardogException {
        aQueryStr = CliUtil.storedQueryString(aQueryStr, theConn);
        switch (SPARQLUtil.getType((String)aQueryStr)) {
            case SELECT: {
                return theConn.select(aQueryStr);
            }
            case PATH: {
                return theConn.paths(aQueryStr);
            }
            case GRAPH: {
                return theConn.graph(aQueryStr);
            }
            case ASK: {
                return theConn.ask(aQueryStr);
            }
            case UPDATE: {
                return theConn.update(aQueryStr);
            }
            case PLAN: {
                return theConn.selectPlan(aQueryStr);
            }
        }
        return null;
    }

    public static String getUserMessage(Throwable e) {
        String aOriginalMsg;
        String aMsg = aOriginalMsg = e.getMessage();
        while (aMsg != null && aMsg.matches("^(([a-zA-Z0-9]*\\.){1,}[a-zA-Z0-9]{1,}:).*")) {
            aMsg = aMsg.substring(aMsg.indexOf(":") + 1).trim();
        }
        return !Strings.isNullOrEmpty((String)aMsg) ? aMsg : (!Strings.isNullOrEmpty((String)aOriginalMsg) ? aOriginalMsg : e.getClass().toString());
    }

    public static void printServerStarted() {
        String serverStartLogFileName = System.getenv().get("SERVER_START_LOG");
        if (serverStartLogFileName != null) {
            File serverStartLogFile = new File(serverStartLogFileName);
            if (!serverStartLogFile.exists()) {
                throw new CliException("File not found " + serverStartLogFileName);
            }
            try {
                Files2.writeString((Path)serverStartLogFile.toPath(), (String)"STARTED");
            }
            catch (IOException e) {
                System.err.println("Cannot write to file: " + serverStartLogFileName);
                e.printStackTrace();
            }
        }
    }

    public static Map<Path, Resource> getFilesAndGraphs(List<String> theFiles) {
        if (theFiles == null || theFiles.isEmpty()) {
            return null;
        }
        HashMap aMap = Maps.newHashMap();
        IRI aGraph = null;
        boolean aGraphArg = false;
        for (String aFile : theFiles) {
            if (aFile.startsWith("@") && (aFile.length() == 1 || !new File(aFile).exists())) {
                if (aGraphArg) {
                    throw new CliException("No files specified for the named graph " + String.valueOf(aGraph));
                }
                aGraphArg = true;
                aGraph = aFile.length() == 1 ? null : Values.iri((String)aFile.substring(1));
                continue;
            }
            Path aPath = Paths.get(aFile, new String[0]);
            aGraphArg = false;
            if (aMap.containsKey(aPath) && !Objects.equals(aGraph, aMap.get(aPath))) {
                throw new CliException("Multiple named graphs specified for file " + String.valueOf(aPath));
            }
            aMap.put(aPath, aGraph);
        }
        if (aGraphArg) {
            throw new CliException("No files specified for the named graph " + String.valueOf(aGraph));
        }
        return aMap;
    }
}

