/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.protocols.http.admin.CheckpointOptions;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

@Command(name="checkpoint", description="Create or restore a database checkpoint.", discussion="A checkpoint is quick backup of a specific database. It differs from a traditional backup in that its scope is limited to one database, not the entire set of data contained within Stardog. The checkpoint images exist within the STARDOG_HOME directory. Initially, a checkpoint shares the disk space of the running database. The checkpoint and running database slowly evolve into two independent instances of data.\t Each requiring an independent amount of disk space. The execution of a \"db optimize\" command causes each database instance, the checkpoint and the running database, to immediately consume equivalent amounts of storage space. ", examples={"* List the available checkpoints for database db1:", "\t   $ stardog-admin db checkpoint list db1", "", "* Immediately create a checkpoint for database db1, with optional comment:", "\t   $ stardog-admin db checkpoint create db1 \"comment about checkpoint reason\"", "", "* Replace running database db1 with checkpoint as named in checkpoint list:", "\t   $ stardog-admin db checkpoint restore db1 checkpoint_name", "", "* Replace running system database with previous checkpoint, including transaction and naming:", "\t   $ stardog-admin db checkpoint restore system checkpoint_name --restore-transactions --restore-naming", "\t   $ stardog-admin server stop", "\t   $ stardog-admin server start", ""})
public final class Checkpoint
extends SecureStardogAdminCommand<Void> {
    @Option(name={"--restore-transactions"}, title="Restore transaction list", description="Only applies to a system database restore.\t Stardog will also restore the transaction list.  Restoring an older transaction list is dangerous.  It is likely that segments of user data will \"disappear\".")
    public boolean mRestoreTransactions = false;
    @Option(name={"--restore-naming"}, title="Restore database name list", description="Only applies to a system database restore.\t Stardog will also restore the database name list.\tThere is a slight risk that databases added since the checkpoint will become inaccessible.")
    public boolean mRestoreNaming = false;
    @Arguments(title={"args"}, description=".")
    public List<String> mArgs;

    @Inject
    public Checkpoint(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Options aOptions = Options.create();
        if (null != this.mArgs) {
            int argSize = this.mArgs.size();
            switch (this.mArgs.get(0)) {
                case "list": {
                    if (2 == argSize) {
                        aOptions.set(CheckpointOptions.CHECKPOINT_OPERATION, (Object)"list");
                        Collection aCheckpoints = theConn.checkpoint(this.mArgs.get(1), aOptions);
                        if (!aCheckpoints.isEmpty()) {
                            TextTabularOutput aTable = new TextTabularOutput((OutputStream)System.out, new String[]{"Checkpoints"});
                            for (String aCheckpoint : aCheckpoints) {
                                aTable.addRow(new Object[]{aCheckpoint});
                            }
                            aTable.output();
                            break;
                        }
                        System.out.println(Checkpoint.get("checkpoint.list.no.checkpoints", new Object[0]));
                        break;
                    }
                    throw new CliException(Checkpoint.get("checkpoint.error.list.param", new Object[0]));
                }
                case "create": {
                    if (2 == argSize || 3 == argSize) {
                        aOptions.set(CheckpointOptions.CHECKPOINT_OPERATION, (Object)"create");
                        if (3 == argSize) {
                            aOptions.set(CheckpointOptions.CHECKPOINT_CREATE_MESSAGE, (Object)this.mArgs.get(2));
                        }
                    } else {
                        throw new CliException(Checkpoint.get("checkpoint.error.create.param", new Object[0]));
                    }
                    Collection aCreated = theConn.checkpoint(this.mArgs.get(1), aOptions);
                    if (!aCreated.isEmpty()) {
                        String[] name = aCreated.toArray(new String[0]);
                        System.out.println(Checkpoint.get("checkpoint.create.name", name[0]));
                        break;
                    }
                    System.out.println(Checkpoint.get("checkpoint.error.create.fail", new Object[0]));
                    break;
                }
                case "restore": {
                    if (3 == argSize) {
                        aOptions.set(CheckpointOptions.CHECKPOINT_OPERATION, (Object)"restore");
                        aOptions.set(CheckpointOptions.CHECKPOINT_RESTORE_CHECKPOINT, (Object)this.mArgs.get(2));
                        aOptions.set(CheckpointOptions.CHECKPOINT_RESTORE_TRANSACTIONS, (Object)this.mRestoreTransactions);
                        aOptions.set(CheckpointOptions.CHECKPOINT_RESTORE_NAMING, (Object)this.mRestoreNaming);
                        if (!this.mArgs.get(1).equals("system") && (this.mRestoreTransactions || this.mRestoreNaming)) {
                            throw new CliException(Checkpoint.get("checkpoint.error.restore.system.only", new Object[0]));
                        }
                        Collection aIgnored = theConn.checkpoint(this.mArgs.get(1), aOptions);
                        System.out.println(Checkpoint.get("checkpoint.restore.system.ready", this.mArgs.get(2)));
                        break;
                    }
                    throw new CliException(Checkpoint.get("checkpoint.error.restore.param", new Object[0]));
                }
                default: {
                    System.out.printf("\t %s command is unknown\n", this.mArgs.get(0));
                }
            }
        } else {
            System.out.printf("performSecure reached: (no args)\n", new Object[0]);
        }
    }
}

