/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.ConnectionCredentials;
import com.complexible.stardog.api.LoginConnectionConfiguration;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.Pattern;
import com.complexible.stardog.cli.StardogCommand;
import com.complexible.stardog.cli.impl.AbstractStardogCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.complexible.stardog.security.PasswordFile;
import io.airlift.command.Arguments;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import java.lang.reflect.Field;
import java.net.PasswordAuthentication;
import java.util.Optional;

public abstract class BaseStardogCommand<T>
extends AbstractStardogCommand<T>
implements StardogCommand<T> {
    @Option(type=OptionType.GLOBAL, name={"--krb5"}, description="Use the Kerberos environment.", title="Kerberos")
    public Boolean mUseKrb5 = false;
    @Option(type=OptionType.GLOBAL, name={"--krb5-disable-rdns"}, description="Disable reverse DNS lookup for Kerberos clients.", title="Disable Kerberos RDNS")
    public Boolean mKrb5DisableReverseDns = false;
    protected static final PasswordAuthentication ADMIN_CREDS = new PasswordAuthentication("admin", "admin".toCharArray());
    @Option(name={"--token"}, description="Stardog JWT token", title="token")
    public String mToken = null;
    @Option(name={"-u", "--username"}, description="User name.", title="username")
    public String mUsername = null;
    @Option(name={"-p", "--passwd"}, description="Password.", title="password")
    public String mPassword = null;
    @Option(name={"-P", "--ask-password"}, description="Prompt for password.")
    public boolean mAskForPassword = false;
    @Option(name={"--run-as"}, description="User to impersonate when running the command", title="username")
    public String mRunAs = null;
    protected final PasswordReader mReader;
    protected Options mCredentials;
    private static final String INVALID_NAME_STRING = "The value %s is invalid.";

    public BaseStardogCommand(PasswordReader theReader) {
        this.mReader = theReader;
    }

    protected Options getConnectionOptions(String theURL, String theDb) throws CliException {
        if (this.mCredentials == null) {
            this.mCredentials = Options.create();
            this.mCredentials.set(ConnectionConfiguration.SERVER, (Object)theURL).set(ConnectionConfiguration.DATABASE, (Object)theDb);
            if (this.mToken != null) {
                if (this.mPassword != null || this.mUsername != null) {
                    throw new CliException(BaseStardogCommand.get("cmd.error.token.extra.args", new Object[0]));
                }
                this.mCredentials.set(ConnectionConfiguration.IS_TOKEN, (Object)true).set(ConnectionConfiguration.USERNAME, (Object)"Bearer").set(ConnectionConfiguration.PASSWORD, (Object)this.mToken);
            } else if (this.mUseKrb5.booleanValue()) {
                this.mCredentials.set(LoginConnectionConfiguration.KRB5_REVERSE_DNS, (Object)(this.mKrb5DisableReverseDns == false ? 1 : 0)).set(LoginConnectionConfiguration.CREDENTIALS_SUPPLIER, ConnectionCredentials::getKrb5Credential);
            } else {
                PasswordAuthentication auth = this.computeCredentials(theURL, theDb);
                this.mCredentials.set(ConnectionConfiguration.USERNAME, (Object)auth.getUserName()).set(ConnectionConfiguration.PASSWORD, (Object)String.valueOf(auth.getPassword()));
            }
        }
        return this.mCredentials;
    }

    private PasswordAuthentication computeCredentials(String theURL, String theDb) throws CliException {
        Optional aCreds;
        Optional aPwdOpt;
        PasswordAuthentication aDefaultCreds = ADMIN_CREDS;
        if (this.mPassword == null && !this.mAskForPassword && (aPwdOpt = PasswordFile.get()).isPresent() && (aCreds = ((PasswordFile)aPwdOpt.get()).getCredentials(theURL, theDb, this.mUsername)).isPresent()) {
            this.mUsername = ((PasswordAuthentication)aCreds.get()).getUserName();
            this.mPassword = new String(((PasswordAuthentication)aCreds.get()).getPassword());
            return (PasswordAuthentication)aCreds.get();
        }
        if (this.mUsername == null) {
            this.mUsername = aDefaultCreds.getUserName();
        } else {
            this.mAskForPassword = true;
        }
        if (this.mAskForPassword && this.mPassword == null) {
            this.mPassword = new String(CliUtil.readPassword(this.mReader, BaseStardogCommand.get("auth.password", this.mUsername)));
        }
        if (this.mPassword == null) {
            this.mPassword = new String(aDefaultCreds.getPassword());
        }
        return new PasswordAuthentication(this.mUsername, this.mPassword.toCharArray());
    }

    protected void validateOptionPatterns() throws CliException {
        for (Field aField : this.getClass().getDeclaredFields()) {
            Pattern aPattern;
            if (!aField.getType().equals(String.class) || aField.getAnnotation(Option.class) == null && aField.getAnnotation(Arguments.class) == null || (aPattern = aField.getAnnotation(Pattern.class)) == null) continue;
            try {
                String aValue = (String)aField.get(this);
                String aRegex = aPattern.regex();
                if (aValue == null || aValue.matches(aRegex)) continue;
                throw new CliException(String.format(INVALID_NAME_STRING, aValue));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }
}

