/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.index.IndexOrder;
import com.complexible.stardog.metadata.TextIO;
import com.complexible.stardog.util.backup.BackupOptions;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.Optional;

@Command(name="backup", description="Create a backup of an existing database.", discussion="Create a complete backup copy of a database.  As opposed to export, which is a logical copy and only provides a snapshot of the contents of the database, a backup is a physical copy and preserves database metadata in addition to the contents so an exact copy can be made during a restore.  By default, backups are stored in the '.backup' directory in your Stardog home, but you can use the 'backup.dir' property in your 'stardog.configuration' file to specify a different location for backups or you can override any default using the -t/--to option.  Within the backup directory, backups are stored by database, and for each database, in date-versioned directories.\n\nYour typical backup directory would have a layout similar to this:\n.backup/myDb/2013-10-02\n.backup/myDb/2013-10-11\n.backup/myOtherDb/2013-06-21\n\nWithin each of those directories are the actual backups themselves.  If you want to restore a database from\none of those backups, you will have to use the complete path to the backup, not just the path to the top\nlevel directory as specified by this property, ie, `db restore $STARDOG_HOME/.backup/myDb/2013-10-02`", examples={"* Create a backup of the 'myDatabase' database in the default backup directory:", "    $ stardog-admin db backup myDatabase", "", "* Save the backup of the database 'myDatabase' to a specific directory:", "    $ stardog-admin db backup --to /my/backup/dir myDatabase", "", "* Create a backup using the PSOC index and repairing corruption issues:", "    $ stardog-admin db backup --repair --index PSOC /my/backup/dir myDatabase"})
public final class Backup
extends SecureStardogAdminCommand<Void> {
    @Option(name={"-t", "--to"}, title="backup location", description="Provide a specific location to save the backup; overrides the default location.")
    public String mBackupDir;
    @Option(name={"--index"}, title="index order", description="Specify an index order to be used for creating the backup. Each index order contains the same data so this option has no effect under normal conditions. But if an index corruption is detected via the 'db verify' command then this option can be used to select a specific index order. Allowed values are {SPO, PSO, POS, OSP, SPOC, PSOC, POSC, OSPC}")
    public String mIndexOrder;
    @Option(name={"--repair"}, description="Repair the backup. If an index is corrupted then creating a backup would preserve the corruption. This option enables an additional processing step that will create a clean backup without the corruption. The index will stay corrupted so the clean backup should be restored to fix the corruption. The 'db verify' command should be used prior to this option to check if repair is necessary and possible.", arity=0)
    public boolean isRepair = false;
    @Option(name={"--partial"}, description="When a repairing backup is being generated the operation will fail even if a single triple cannot be repaired. Enabling this option will create the backup with as many triples as possible.", arity=0)
    public boolean isPartial = false;
    @Arguments(description="The database which should be backed up", required=true, title={"db"})
    public String mDb;

    @Inject
    public Backup(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        if (this.mDb == null) {
            throw new CliException(Backup.get("backup.missing.name", new Object[0]));
        }
        Options aOptions = Options.create().set(BackupOptions.REPAIR, (Object)this.isRepair).set(BackupOptions.PARTIAL, (Object)this.isPartial);
        if (this.mIndexOrder != null) {
            IndexOrder aOrder = (IndexOrder)TextIO.forClass(IndexOrder.class).read(this.mIndexOrder);
            aOptions.set(BackupOptions.INDEX_ORDER, (Object)aOrder);
        }
        System.out.println(theConn.backup(this.mDb, Optional.ofNullable(this.mBackupDir), aOptions));
    }
}

