/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.SecureStardogAdminCommand;
import com.complexible.stardog.util.backup.BackupOptions;
import com.google.inject.Inject;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.text.SimpleDateFormat;
import java.util.Date;

@Command(name="backup", description="Creates a backup of all databases in the given Stardog instance", discussion="Creates a backup of all databases in the given Stardog instance. By default, backups are stored in the '.backup' directory in your Stardog home, but you can use the 'backup.dir' property in your 'stardog.configuration' file to specify a different location for backups or you can override any default.", examples={"* Create a backup of all databases in the default backup directory:", "    $ stardog-admin server backup", "", "Create a backup of all databases and save it in the given location:", "    $ stardog-admin server backup /path/to/backup/dir/on/server", "", "Create a backup of all databases, saving to an AWS S3 bucket (special license required):", "    $ stardog-admin server backup s3:///bucket-name/path-in-bucket?region=us-east-1\\&AWS_ACCESS_KEY_ID=<your key id>\\&AWS_SECRET_ACCESS_KEY=<your key secret>"})
public final class BackUpAll
extends SecureStardogAdminCommand<Void> {
    @Arguments(description="Provide a specific location to save the backup on the server side; overrides the default location.", required=false, title={"Backup location"})
    private String mBackupDir;

    @Inject
    public BackUpAll(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void performSecure(AdminConnection theConn) throws StardogException {
        Options aOptions = Options.create();
        SimpleDateFormat aSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm");
        Date now = new Date();
        aOptions.set(BackupOptions.BACKUP_TIMESTAMP, (Object)aSimpleDateFormat.format(now));
        aOptions.set(BackupOptions.BACKUP_URL, (Object)this.mBackupDir);
        System.out.println(theConn.backupAll(aOptions));
    }
}

