/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Adder;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.IO;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ModifyDataWithFiles;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;

@Command(name="add", description="Adds RDF data to a database; prints status on STDOUT.", discussion="Adds data to the database in a single commit; the add operation is atomic: if multiple files are being added to the database and there is an error adding one or more of the files, the entire operation will be rolled back.", examples={"* Add data to the default graph:", "    $ stardog data add myDb file.rdf", "", "* Add data to a specific named graph:", "    $ stardog data add --named-graph http://example.org/context myDb file.rdf", "", "* First clear the database and then add the data:", "    $ stardog data add --remove-all myDb file.rdf", "", "* Add a data file by specifying the format and compression:", "    $ stardog data add -f turtle --compression gzip myDb file.bin", "", "* Add separate files into separate named graphs:", "    $ stardog data add myDb input0.ttl @http://stardog.com/graph/1 input1.ttl input2.ttl @urn:stardog:graph:2 input3.ttl @ input4.ttl", ""})
public final class Add
extends ModifyDataWithFiles {
    @Option(name={"--remove-all"}, type=OptionType.COMMAND, description="Remove all flag. If this flag is set, all data in the database will be removed before additions.", arity=0)
    protected boolean mRemoveAll = false;

    @Inject
    public Add(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public void execute(Connection theConn) throws StardogException {
        boolean isInTx;
        long aStartTime = System.currentTimeMillis();
        boolean bl = isInTx = this.mTxId != null;
        if (!isInTx) {
            theConn.begin();
        }
        try {
            if (this.mRemoveAll) {
                theConn.remove().all();
            }
            Adder aAdder = theConn.add();
            IO aIO = aAdder.io();
            if (this.mServerSide || this.isLocalhost()) {
                aIO = aIO.serverSide();
            }
            if (this.mFiles == null || this.mFiles.isEmpty()) {
                throw new CliException(Add.get("add.error.nofiles", new Object[0]));
            }
            this.loadFiles(aIO, theConn, "add.msg.tofile");
        }
        catch (Throwable e) {
            theConn.rollback();
            throw e;
        }
        Add.commitAndClose(theConn, aStartTime, !isInTx);
    }

    @Override
    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        this.initArgs();
        return this.mDbName;
    }
}

