/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.admin;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.admin.AdminConnection;
import com.complexible.stardog.api.admin.AdminConnectionConfiguration;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.admin.StardogAdminCommand;
import com.complexible.stardog.security.ActionType;
import com.complexible.stardog.security.CoreResourceType;
import com.complexible.stardog.security.OperationNotSupportedException;
import com.complexible.stardog.security.SecurityResourceType;
import com.complexible.stardog.security.SecurityResourceTypes;
import com.complexible.stardog.security.StardogAuthenticationException;
import com.complexible.stardog.security.StardogAuthorizationException;
import com.complexible.stardog.server.StardogConnectionException;
import com.google.common.base.Joiner;
import java.net.ConnectException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecureStardogAdminCommand<T>
extends StardogAdminCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureStardogAdminCommand.class);

    public SecureStardogAdminCommand(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    public final T call() throws Exception {
        this.validateOptionPatterns();
        try (AdminConnection aConn = this.connect();){
            this.performSecure(aConn);
        }
        catch (StardogAuthorizationException e) {
            LOGGER.error("Failed to gain authorization", (Throwable)e);
            throw new CliException(SecureStardogAdminCommand.get("auth.permission.denied", new Object[0]));
        }
        catch (StardogAuthenticationException e) {
            LOGGER.error("Failed to be authenticated", (Throwable)e);
            throw new CliException(SecureStardogAdminCommand.get("auth.failed", new Object[0]));
        }
        catch (OperationNotSupportedException e) {
            throw new CliException(SecureStardogAdminCommand.get("auth.operation.not.supported", new Object[0]));
        }
        return null;
    }

    public abstract void performSecure(AdminConnection var1) throws Exception;

    protected AdminConnection connect() throws StardogException {
        String aServer = this.getServerURL(this.mServerURL);
        AdminConnectionConfiguration aAdminConnectionConfiguration = AdminConnectionConfiguration.toServer((String)aServer);
        aAdminConnectionConfiguration.setAll(this.getConnectionOptions(aServer, "admin"));
        if (this.mRunAs != null) {
            aAdminConnectionConfiguration = aAdminConnectionConfiguration.runningAs(this.mRunAs);
        }
        try {
            return aAdminConnectionConfiguration.connect();
        }
        catch (StardogException e) {
            LOGGER.debug("Failed to connect", (Throwable)e);
            if (e instanceof StardogAuthenticationException || e.getCause() instanceof StardogAuthenticationException) {
                throw new CliException(SecureStardogAdminCommand.get("auth.failed", new Object[0]));
            }
            if (e.getCause() instanceof ConnectException || (e.getCause() instanceof StardogException || e.getCause() instanceof StardogConnectionException) && e.getCause().getCause() instanceof ConnectException) {
                throw new CliException(SecureStardogAdminCommand.get("admin.connect.failed", aServer, e.getCause().getMessage()));
            }
            if (e.getCause() != null && e.getCause().getClass().getSimpleName().equals("NoHttpResponseException")) {
                throw new CliException(SecureStardogAdminCommand.get("admin.connect.failed", aServer, e.getCause().getMessage()));
            }
            throw e;
        }
    }

    protected Connection connection(String theDatabase) {
        String aServer = this.getServerURL(this.mServerURL);
        try {
            return (Connection)ConnectionConfiguration.to((String)theDatabase).server(aServer).setAll(this.getConnectionOptions(aServer, "admin")).connect();
        }
        catch (StardogException e) {
            if (e instanceof StardogAuthenticationException || e.getCause() instanceof StardogAuthenticationException) {
                throw new CliException(SecureStardogAdminCommand.get("auth.failed", new Object[0]));
            }
            if (e.getCause() instanceof ConnectException || (e.getCause() instanceof StardogException || e.getCause() instanceof StardogConnectionException) && e.getCause().getCause() instanceof ConnectException) {
                throw new CliException(SecureStardogAdminCommand.get("admin.connect.failed", aServer, e.getCause().getMessage()));
            }
            if (e.getCause() != null && e.getCause().getClass().getSimpleName().equals("NoHttpResponseException")) {
                throw new CliException(SecureStardogAdminCommand.get("admin.connect.failed", aServer, e.getCause().getMessage()));
            }
            throw e;
        }
    }

    protected final ActionType getActionType(String theName) {
        theName = theName.equals("*") ? "all" : theName;
        for (ActionType aActionType : ActionType.values()) {
            if (!aActionType.toString().equals(theName)) continue;
            return aActionType;
        }
        return null;
    }

    protected final SecurityResourceType getResourceType(@Nonnull String theName) {
        String[] aParts = theName.split(":");
        if (aParts.length < 1) {
            throw new IllegalArgumentException("Missing required resource type.");
        }
        for (CoreResourceType aResourceType : CoreResourceType.values()) {
            if (!aResourceType.toString().equals(aParts[0])) continue;
            return aResourceType;
        }
        return SecurityResourceTypes.get((String)aParts[0]);
    }

    protected final String getResourceName(String theName) {
        String[] aParts = theName.split(":");
        if (aParts.length < 2) {
            throw new CliException(SecureStardogAdminCommand.get("grant.invalid.resource.type", theName));
        }
        return Joiner.on((String)":").join((Object[])Arrays.copyOfRange(aParts, 1, aParts.length));
    }
}

