/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli.admin;

import com.complexible.common.inject.Injectors;
import com.complexible.common.util.ServiceLoaders;
import com.complexible.stardog.Environment;
import com.complexible.stardog.cli.CLIBase;
import com.complexible.stardog.cli.CLIBinding;
import com.complexible.stardog.cli.CLIModule;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.InjectorCommandFactory;
import com.complexible.stardog.cli.admin.AdminCli;
import com.complexible.stardog.cli.impl.BackUpAll;
import com.complexible.stardog.cli.impl.Backup;
import com.complexible.stardog.cli.impl.Checkpoint;
import com.complexible.stardog.cli.impl.CrashReport;
import com.complexible.stardog.cli.impl.Create;
import com.complexible.stardog.cli.impl.Delete;
import com.complexible.stardog.cli.impl.LicenseRequest;
import com.complexible.stardog.cli.impl.ListDbs;
import com.complexible.stardog.cli.impl.MetadataConvert;
import com.complexible.stardog.cli.impl.MetadataGet;
import com.complexible.stardog.cli.impl.MetadataSet;
import com.complexible.stardog.cli.impl.Offline;
import com.complexible.stardog.cli.impl.Online;
import com.complexible.stardog.cli.impl.Optimize;
import com.complexible.stardog.cli.impl.Passwd;
import com.complexible.stardog.cli.impl.PrintLicenseInfo;
import com.complexible.stardog.cli.impl.ProcessKill;
import com.complexible.stardog.cli.impl.ProcessList;
import com.complexible.stardog.cli.impl.ProcessStatus;
import com.complexible.stardog.cli.impl.PropertyGet;
import com.complexible.stardog.cli.impl.PropertySet;
import com.complexible.stardog.cli.impl.QueryKill;
import com.complexible.stardog.cli.impl.QueryList;
import com.complexible.stardog.cli.impl.QueryStatus;
import com.complexible.stardog.cli.impl.RenameDatabase;
import com.complexible.stardog.cli.impl.Repair;
import com.complexible.stardog.cli.impl.Restore;
import com.complexible.stardog.cli.impl.RoleAdd;
import com.complexible.stardog.cli.impl.RoleDrop;
import com.complexible.stardog.cli.impl.RoleGrant;
import com.complexible.stardog.cli.impl.RoleList;
import com.complexible.stardog.cli.impl.RolePermission;
import com.complexible.stardog.cli.impl.RoleRevoke;
import com.complexible.stardog.cli.impl.SensitivePropertyAdd;
import com.complexible.stardog.cli.impl.SensitivePropertyList;
import com.complexible.stardog.cli.impl.SensitivePropertyRemove;
import com.complexible.stardog.cli.impl.ServerLogs;
import com.complexible.stardog.cli.impl.ServerMetrics;
import com.complexible.stardog.cli.impl.ServerStatus;
import com.complexible.stardog.cli.impl.ServerStop;
import com.complexible.stardog.cli.impl.Status;
import com.complexible.stardog.cli.impl.StoredFunctionAdd;
import com.complexible.stardog.cli.impl.StoredFunctionList;
import com.complexible.stardog.cli.impl.StoredFunctionRemove;
import com.complexible.stardog.cli.impl.StoredQueryAdd;
import com.complexible.stardog.cli.impl.StoredQueryExport;
import com.complexible.stardog.cli.impl.StoredQueryGet;
import com.complexible.stardog.cli.impl.StoredQueryImport;
import com.complexible.stardog.cli.impl.StoredQueryList;
import com.complexible.stardog.cli.impl.StoredQueryMove;
import com.complexible.stardog.cli.impl.StoredQueryRemove;
import com.complexible.stardog.cli.impl.StoredQueryRename;
import com.complexible.stardog.cli.impl.StoredQuerySet;
import com.complexible.stardog.cli.impl.UserAdd;
import com.complexible.stardog.cli.impl.UserAddRole;
import com.complexible.stardog.cli.impl.UserCreateToken;
import com.complexible.stardog.cli.impl.UserDisable;
import com.complexible.stardog.cli.impl.UserDrop;
import com.complexible.stardog.cli.impl.UserEnable;
import com.complexible.stardog.cli.impl.UserGrant;
import com.complexible.stardog.cli.impl.UserList;
import com.complexible.stardog.cli.impl.UserPermission;
import com.complexible.stardog.cli.impl.UserRemoveRole;
import com.complexible.stardog.cli.impl.UserRevoke;
import com.complexible.stardog.cli.impl.Verify;
import com.complexible.stardog.cli.impl.Version;
import com.complexible.stardog.cli.impl.tx.TxLogExportCommand;
import com.complexible.stardog.cli.impl.tx.TxLogReplayCommand;
import com.google.common.collect.Sets;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.airlift.command.Cli;
import io.airlift.command.Help;
import java.io.File;
import java.util.Set;

public class CLI
extends CLIBase {
    public static final String HOME_FLAG = "--home";
    private static final String STARDOG_SCRIPT = "stardog-admin";
    private static CLI INSTANCE;

    @Inject
    CLI(Injector theInjector, OptionalParam theCLIBinders) {
        Cli.CliBuilder aBuilder = Cli.builder((String)STARDOG_SCRIPT);
        aBuilder.withCommandFactory(new InjectorCommandFactory(theInjector));
        aBuilder.withDefaultCommand(Help.class);
        aBuilder.withNavOrder(Integer.valueOf(25));
        aBuilder.withDescription("As described in the [Command Line Interface](../operating-stardog/command-line-interface) section of [Operating Stardog](../operating-stardog), Stardog's CLI comes in two parts, `stardog-admin` (the administrative client) and `stardog` (a Stardog user's client). The CLI tools use \u201ccommand groups\u201d to make CLI subcommands easier to find.");
        aBuilder.withCommands(Help.class, new Class[]{Version.class});
        aBuilder.withGroup("server").withDescription("Commands which work with the Stardog DBMS server").withMarkdownDescription("Server Administration is a multi-faceted topic in Stardog. Read more about [Server Administration](../../operating-stardog/server-administration).").withCommands(ServerStop.class, new Class[]{ServerStatus.class, ServerMetrics.class, ServerLogs.class, BackUpAll.class});
        aBuilder.withGroup("db").withDescription("Commands for working with databases").withMarkdownDescription("Database Administration is a multi-faceted topic in Stardog. Read more about [Database Administration](../../operating-stardog/database-administration).").withCommands(Checkpoint.class, new Class[]{Create.class, Delete.class, RenameDatabase.class, ListDbs.class, Optimize.class, Online.class, Offline.class, Status.class, Backup.class, Restore.class, Repair.class, Verify.class});
        aBuilder.withGroup("role").withDescription("Commands for working with roles").withMarkdownDescription("Stardog\u2019s security model is based on standard role based access control: users have permissions over resources during sessions; permissions can be grouped into roles; and roles can be assigned to users. Read more about [permissions](../../operating-stardog/security/security-model).").withCommands(RoleAdd.class, new Class[]{RoleDrop.class, RoleGrant.class, RoleList.class, RolePermission.class, RoleRevoke.class});
        aBuilder.withGroup("user").withDescription("Commands for working with users").withMarkdownDescription("Stardog\u2019s security model is based on standard role-based access control: users have permissions over resources during sessions; permissions can be grouped into roles; and roles can be assigned to users. Read more about [permissions](../../operating-stardog/security/security-model).").withCommands(UserAdd.class, new Class[]{UserEnable.class, UserDisable.class, UserAddRole.class, UserRemoveRole.class, UserDrop.class, UserGrant.class, UserList.class, UserRevoke.class, UserPermission.class, Passwd.class, UserCreateToken.class});
        aBuilder.withGroup("metadata").withDescription("Modify the properties of a database").withMarkdownDescription("Stardog Databases have a variety of configuration options. All configuration options have sensible default, but often times you'll want to inspect some options and make changes. A database's configuration options are often referred to as its metadata, hence this command group name. Read more about [Database Options](../../operating-stardog/database-administration/database-configuration).").withCommands(MetadataGet.class, new Class[]{MetadataSet.class, MetadataConvert.class});
        aBuilder.withGroup("property").withDescription("Commands for viewing and modifying server properties").withMarkdownDescription("Read more about [server configuration options](../../operating-stardog/server-administration/server-configuration).").withCommands(PropertyGet.class, new Class[]{PropertySet.class});
        aBuilder.withGroup("ps").withDescription("Process management commands").withMarkdownDescription("Stardog includes the capability to manage running processes. Read more about [Process Management](../../operating-stardog/database-administration/process-management).").withDefaultCommand(ProcessList.class).withCommands(ProcessKill.class, new Class[]{ProcessList.class, ProcessStatus.class});
        aBuilder.withGroup("query").withDescription("Query management commands").withMarkdownDescription("Stardog includes the capability to manage running queries. Read more about [Query Management](../../operating-stardog/database-administration/query-management).").withCommands(QueryKill.class, new Class[]{QueryList.class, QueryStatus.class});
        aBuilder.withGroup("stored").withDescription("Stored query management commands").withMarkdownDescription("Stardog has the capability to name and store SPARQL queries for future evaluation by referring to the query\u2019s name. Read more about [Stored Queries](../../operating-stardog/database-administration/stored queries).").withCommands(StoredQueryList.class, new Class[]{StoredQueryAdd.class, StoredQueryRemove.class, StoredQueryRename.class, StoredQueryMove.class, StoredQueryImport.class, StoredQueryExport.class, StoredQueryGet.class, StoredQuerySet.class});
        aBuilder.withGroup("function").withDescription("Stored function management commands").withMarkdownDescription("Stored functions provide the ability to reuse expressions when writing queries. Read more about administering [stored functions](../../operating-stardog/database-administration/stored-functions).").withCommands(StoredFunctionList.class, new Class[]{StoredFunctionAdd.class, StoredFunctionRemove.class});
        aBuilder.withGroup("license").withDescription("License commands").withMarkdownDescription("Stardog requires a license in order to start up. Anyone can obtain a free license on the [Getting Started Page](https://www.stardog.com/get-started).").withCommands(PrintLicenseInfo.class, new Class[]{LicenseRequest.class});
        aBuilder.withGroup("diagnostics").withDescription("Commands to help diagnose your Stardog server").withMarkdownDescription("When reaching out to Stardog Support, it's almost always helpful to execute the following diagnostics commands. Read more about [Getting Support](../../getting-support).").withCommands(CrashReport.class, new Class[0]);
        aBuilder.withGroup("sensitive-property").withDescription("Commands to manage sensitive properties").withMarkdownDescription("Stardog restricts access to sensitive information by indicating that only particular users can read values of particular properties (i.e., sensitive properties). All that is required is to add a property to a list of sensitive properties and grant the permission to access sensitive properties to the right users. For more information on sensitive properties, please see the [Fine Grained Security](../../operating-stardog/security/fine-grained-security.md) section.").withCommands(SensitivePropertyList.class, new Class[]{SensitivePropertyAdd.class, SensitivePropertyRemove.class});
        aBuilder.withGroup("tx").withDescription("Commands for working with the transaction log").withMarkdownDescription("Commands for working with the transaction log. Allows exporting and viewing a transaction log from a server, as well as replaying a transaction log onto an existing database.").withCommands(TxLogExportCommand.class, new Class[]{TxLogReplayCommand.class});
        for (CLIBinding aBinding : theCLIBinders.or(Sets.newHashSet())) {
            aBinding.bind(aBuilder);
        }
        this.mParser = aBuilder.build();
    }

    private static boolean isHome(String arg) {
        return arg.startsWith(HOME_FLAG);
    }

    public static CLI instance() {
        if (INSTANCE == null) {
            INSTANCE = (CLI)Guice.createInjector((Iterable)ServiceLoaders.instancesOf(CLIModule.class)).getInstance(CLI.class);
        }
        return INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        boolean aFoundHome = false;
        for (int i = 0; i < args.length; ++i) {
            if (!CLI.isHome(args[i]) || i + 1 >= args.length) continue;
            Environment.checkHome((File)new File(args[i + 1]));
            System.setProperty("stardog.home", args[i + 1]);
            aFoundHome = true;
        }
        if (!aFoundHome) {
            Environment.assertHome();
        }
        try {
            int aExitCode = Math.abs(CLI.instance().execute(args));
            if (aExitCode != 0) {
                System.exit(aExitCode);
            }
        }
        catch (Error | Exception e) {
            CLI.endWithError(e);
        }
    }

    private static void endWithError(Throwable e) {
        try {
            System.err.println("An unexpected error occurred.");
            if (e instanceof CreationException) {
                CreationException ex = (CreationException)e;
                Injectors.prettyPrintErrors((Iterable)ex.getErrorMessages());
            } else if (e instanceof CliException) {
                System.err.println(e.getMessage());
            } else {
                System.err.println(e.toString());
            }
        }
        finally {
            System.exit(33);
        }
    }

    public static final class OptionalParam {
        @AdminCli
        @Inject(optional=true)
        private Set<CLIBinding> value;

        @Inject
        public OptionalParam() {
        }

        public Set<CLIBinding> or(Set<CLIBinding> theDefaultValue) {
            if (this.value == null) {
                return theDefaultValue;
            }
            return this.value;
        }
    }
}

