/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli;

import com.complexible.common.rdf.query.resultio.HTMLQueryResultWriter;
import com.complexible.common.rdf.query.resultio.TextTableQueryResultWriter;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.impl.ReasonableConnectionCommand;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import io.airlift.command.Arguments;
import java.io.File;
import java.util.List;
import java.util.Map;

public abstract class QueryCommand<T>
extends ReasonableConnectionCommand<T> {
    public static Map<String, QueryResultFormat> OUTPUT_FORMATS = ImmutableMap.builder().put((Object)"SPARQL", (Object)QueryResultFormats.XML).put((Object)"JSON", (Object)QueryResultFormats.JSON).put((Object)"TEXT", (Object)TextTableQueryResultWriter.FORMAT).put((Object)"TABLE", (Object)TextTableQueryResultWriter.FORMAT).put((Object)"CSV", (Object)QueryResultFormats.CSV).put((Object)"TSV", (Object)QueryResultFormats.TSV).put((Object)"HTML", (Object)HTMLQueryResultWriter.FORMAT).build();
    @Arguments(required=true, description="The name of the database or the full connection string of the database to connect to. If only the name is provided, the default server URL will be prepended to the name of the database in order to construct the connection string. Connection parameters such as ';reasoning=true' can be included in the provided database name. Connection parameters specified like this can be overridden by specific options on the command. The default server URL will be read from the JVM argument 'stardog.default.cli.server'. If the JVM argument is not set, the default value 'http://localhost:5820' is used. If the server URL has no explicit port value, the default port value '5820' is used.  To use a secure connection, you should specify the full connection string and postfix 's' to the protocol, e.g. https. The subsequent argument is the SPARQL query string to execute.  This can either be a file name, a SPARQL query string, or a stored query name.", title={"database", "query"})
    public final List<String> mArgs = Lists.newArrayList();
    protected String mDbName;
    protected String mQuery;
    protected boolean mIsFile;
    protected File mFile;

    public QueryCommand(PasswordReader theReader) {
        super(theReader);
    }

    @Override
    protected String connectionString() {
        if (this.mDbName != null) {
            return this.mDbName;
        }
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            this.mDbName = this.mArgs.get(0);
            if (this.mArgs.size() > 1) {
                String aParam = this.mArgs.get(1);
                this.mIsFile = new File(aParam).exists();
                this.mFile = new File(aParam);
                if (!this.mFile.exists()) {
                    this.mQuery = aParam;
                }
            }
        }
        return this.mDbName;
    }
}

