/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli;

import com.complexible.common.io.Files2;
import com.complexible.common.rdf.rio.TurtleValueParser;
import com.complexible.stardog.Contexts;
import com.complexible.stardog.api.Query;
import com.complexible.stardog.api.ReadQuery;
import com.complexible.stardog.cli.CliException;
import com.complexible.stardog.cli.PasswordReader;
import com.complexible.stardog.cli.QueryCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Values;
import com.stardog.stark.query.Datasets;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class ParameterizedQueryCommand<T>
extends QueryCommand<T> {
    @Option(description="Variable bindings. One or more variable bindings to apply before executing query. Each binding is provided as a 'var=value' pair; multiple bindings should be separated with whitespaces. Variables must exist in the query and the value should be a valid RDF term in Turtle syntax. Namespaces stored in the database can be used in the values; e.g. x=ex:name. Quotes are needed around IRIs to avoid special characters to be evaluated by the shell; e.g. y=\"<http://example.org/test>\". In Turtle syntax literals have quotes which need to be escaped to differentiate them from shell quotes; e.g. z=\\\"value\\\". Finally, if a literal contains special characters or a space then additional quotes are needed for the shell; e.g. z=\"\\\"another value\\\"\".", name={"-b", "--bind"}, arity=0x7FFFFFFF, title="variables to bind")
    public final List<String> mVarsToBind = new ArrayList<String>();
    @Option(description="Query hints. One or more query hints to pass to the query execution engine. Each hint is provided as a 'hint=value' pair; multiple hints should be separated with whitespaces. The hints will apply to the query as a whole, i.e. as if they are specified at the top of the query string, not in some specific part of the query.", name={"-h", "--hint"}, arity=0x7FFFFFFF, title="query hints")
    public final List<String> mHints = new ArrayList<String>();
    @Option(name={"-g", "--default-graph"}, description="Default graph(s) to run the queries against (equivalent to FROM in SPARQL). Can include wildcards: ALL, LOCAL, NAMED, and VIRTUAL.", title="Default graphs")
    public List<String> mDefaultGraphs = null;
    @Option(name={"--named-graph"}, description="Named graph(s) to run the queries against (equivalent to FROM NAMED in SPARQL). Can include wildcards: ALL, LOCAL, NAMED, and VIRTUAL.", title="Named graphs")
    public List<String> mNamedGraphs = null;
    @Option(name={"--exclude-graph"}, description="Graphs to exclude from the default and named scopes in the query.", title="Exclude graphs")
    public List<String> mExcludeGraphs = null;
    @Option(name={"-l", "--limit"}, description="Limit the number of results the query will return. Specifying the limit will override any limit specified in the original query string", title="N")
    public long mLimit = -1L;
    @Option(name={"-o", "--offset"}, description="Skip the first N results the query will return. Specifying the offset will override any offset specified in the original query string", title="N")
    public long mOffset = -1L;

    public ParameterizedQueryCommand(PasswordReader theReader) {
        super(theReader);
    }

    protected Query<?> readQuery(Function<String, Query<?>> theQueryFactory, Supplier<Iterable<Namespace>> aNamespaces) {
        return this.createQuery(ParameterizedQueryCommand.readQueryString(this.mIsFile && this.mFile.exists() ? this.mFile : null, this.mQuery), theQueryFactory, aNamespaces);
    }

    public static String readQueryString(File file, String argQuery) {
        boolean aIsDefinitelyFile;
        String aQueryStr = null;
        boolean aIsQuery = argQuery != null && !argQuery.equals("");
        boolean bl = aIsDefinitelyFile = file != null;
        if (!aIsDefinitelyFile && aIsQuery && ((file = new File(argQuery)).exists() || Pattern.matches("^(\\.{0,2}[\\\\|/]|([a-z|A-Z]:[\\\\|/]{2})).*", argQuery))) {
            aIsDefinitelyFile = true;
        }
        if (aIsDefinitelyFile) {
            if (!file.exists()) {
                throw new CliException(ParameterizedQueryCommand.get("query.error.nofile", new Object[0]));
            }
            try {
                aQueryStr = Files2.toString((Path)file.toPath(), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new CliException(e);
            }
        } else if (aIsQuery) {
            aQueryStr = argQuery;
        } else {
            throw new CliException(ParameterizedQueryCommand.get("query.error.noquery", new Object[0]));
        }
        aQueryStr = CliUtil.cleanQuery(aQueryStr);
        return aQueryStr;
    }

    private Set<IRI> parseNamedGraphs(List<String> graphs) {
        if (graphs == null || graphs.isEmpty()) {
            return Set.of();
        }
        return graphs.stream().map(this::parseNamedGraph).collect(Collectors.toSet());
    }

    private IRI parseNamedGraph(String graph) {
        if (!graph.equalsIgnoreCase("DEFAULT")) {
            if (graph.equalsIgnoreCase("ALL")) {
                return Contexts.ALL;
            }
            if (graph.equalsIgnoreCase("LOCAL")) {
                return Contexts.LOCAL;
            }
            if (graph.equalsIgnoreCase("NAMED")) {
                return Contexts.NAMED;
            }
            if (graph.equalsIgnoreCase("VIRTUAL")) {
                return Contexts.VIRTUAL;
            }
            return Values.iri((String)graph);
        }
        return Contexts.DEFAULT;
    }

    protected Query<?> createQuery(String theQueryStr, Function<String, Query<?>> theQueryFactory, Supplier<Iterable<Namespace>> theNamespaces) {
        try {
            Datasets.DatasetImpl.Builder dsBuilder;
            Query<?> aQuery = theQueryFactory.apply(theQueryStr);
            this.addParameters(aQuery, theNamespaces);
            this.addHints(aQuery);
            Set<IRI> defaultGraphs = this.parseNamedGraphs(this.mDefaultGraphs);
            Set<IRI> namedGraphs = this.parseNamedGraphs(this.mNamedGraphs);
            Set<IRI> excludeGraphs = this.parseNamedGraphs(this.mExcludeGraphs);
            Object object = dsBuilder = !defaultGraphs.isEmpty() || !namedGraphs.isEmpty() || !excludeGraphs.isEmpty() ? Datasets.builder() : null;
            if (!defaultGraphs.isEmpty()) {
                dsBuilder.defaultGraphs(defaultGraphs);
            }
            if (!namedGraphs.isEmpty()) {
                dsBuilder.namedGraphs(namedGraphs);
            }
            if (!excludeGraphs.isEmpty()) {
                dsBuilder.excludeGraphs(excludeGraphs);
            }
            if (dsBuilder != null) {
                aQuery.dataset(dsBuilder.build());
            }
            if (aQuery instanceof ReadQuery) {
                ((ReadQuery)aQuery).offset(this.mOffset).limit(this.mLimit);
            }
            return aQuery;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, CliException.class);
            throw new CliException(ParameterizedQueryCommand.get("query.error.parse", MoreObjects.firstNonNull((Object)Throwables.getRootCause((Throwable)e).getMessage(), (Object)e.getClass().getSimpleName())));
        }
    }

    protected void addParameters(Query<?> query, Supplier<Iterable<Namespace>> namespaces) throws CliException {
        if (this.mVarsToBind.isEmpty()) {
            return;
        }
        TurtleValueParser parser = new TurtleValueParser(namespaces.get());
        this.mVarsToBind.forEach(entry -> {
            String[] aBinding = entry.split("=", 2);
            if (aBinding.length != 2) {
                throw new CliException("Invalid binding: " + entry);
            }
            try {
                query.parameter(aBinding[0], parser.parse(aBinding[1]));
            }
            catch (Exception e) {
                throw new CliException("Invalid bind value: " + entry);
            }
        });
    }

    protected void addHints(Query<?> query) throws CliException {
        this.mHints.forEach(entry -> {
            String[] hintVal = entry.split("=", 2);
            if (hintVal.length != 2) {
                throw new CliException("Invalid hint entry: " + entry);
            }
            query.hint(hintVal[0].trim(), hintVal[1].trim());
        });
    }
}

