/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli;

import com.complexible.stardog.cli.impl.AbstractStardogCommand;
import com.complexible.stardog.cli.impl.CliUtil;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.airlift.command.Cli;
import io.airlift.command.Command;
import io.airlift.command.ParseException;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class CLIBase {
    protected Cli<Callable<?>> mParser = null;

    protected CLIBase() {
    }

    public int execute(String ... theArgs) {
        boolean aError;
        block6: {
            aError = true;
            Callable aCmd = null;
            try {
                aCmd = (Callable)this.mParser.parse(theArgs);
                aCmd.call();
                aError = false;
            }
            catch (ParseException e) {
                this.showParseError(theArgs, e.getMessage());
            }
            catch (Exception e) {
                Throwable t = Throwables.getRootCause((Throwable)e);
                if (t instanceof UnsupportedOperationException && t.getMessage() != null && t.getMessage().startsWith("Unknown or unsupported")) {
                    String aCmdName;
                    String aGroup = theArgs.length > 0 ? theArgs[0] : null;
                    String aName = (aGroup != null ? aGroup : "") + (aGroup != null ? " " : "") + ((aCmdName = aCmd != null ? aCmd.getClass().getAnnotation(Command.class).name() : null) != null ? aCmdName : "");
                    if (!Strings.isNullOrEmpty((String)aName)) {
                        System.out.println("'" + aName + "' is not supported by the server.");
                    } else {
                        System.out.println("The command is not supported by the server.");
                    }
                    return 1;
                }
                System.out.println(CliUtil.getUserMessage(e));
                if (aCmd instanceof AbstractStardogCommand && !((AbstractStardogCommand)aCmd).mVerbose) break block6;
                System.out.println("The detailed stack trace for the error is:");
                e.printStackTrace(System.out);
            }
        }
        return aError ? 1 : 0;
    }

    private void showParseError(String[] theArgs, String theExceptionMsg) {
        System.out.println("Invalid or missing options:");
        System.out.println(theExceptionMsg);
        Object aGroupName = "";
        if (this.mParser != null) {
            String aPossibleGroupName = this.possibleGroup(theArgs);
            aGroupName = this.availableGroups().contains(aPossibleGroupName) ? " " + aPossibleGroupName : "";
        }
        Object aCommandName = "";
        int aGroupNameIndex = Lists.newArrayList((Object[])theArgs).indexOf(((String)aGroupName).trim());
        if (!((String)aGroupName).isEmpty() && aGroupNameIndex < theArgs.length - 1 && aGroupNameIndex >= 0) {
            String aPossibleCommand = theArgs[aGroupNameIndex + 1];
            aCommandName = this.availableCommandsFor(((String)aGroupName).trim()).contains(aPossibleCommand) ? " " + aPossibleCommand : "";
        }
        String aHelpMsg = String.format("Type 'help%s%s' for usage information", aGroupName, aCommandName);
        System.out.println(aHelpMsg);
    }

    private String possibleGroup(String[] theArgs) {
        if (theArgs == null) {
            return null;
        }
        String aGroupName = null;
        boolean aFoundOption = false;
        for (int i = 0; i < theArgs.length; ++i) {
            String aToken = theArgs[i];
            if (!aToken.startsWith("-") && i == 0) {
                aGroupName = aToken;
                break;
            }
            if (aToken.startsWith("-")) {
                aFoundOption = true;
                continue;
            }
            if (!aToken.startsWith("-") && aFoundOption) {
                aFoundOption = false;
                continue;
            }
            if (aToken.startsWith("-") || aFoundOption) continue;
            aGroupName = aToken;
            break;
        }
        return aGroupName;
    }

    public List<String> availableGroups() {
        ArrayList aAvailableGroups = Lists.newArrayList();
        for (CommandGroupMetadata aMeta : this.mParser.getMetadata().getCommandGroups()) {
            if (!aMeta.getCommands().stream().anyMatch(cmd -> !cmd.isHidden())) continue;
            aAvailableGroups.add(aMeta.getName());
        }
        return aAvailableGroups;
    }

    public List<String> availableCommandsFor(String theGroup) {
        ArrayList aAvailableCommands = Lists.newArrayList();
        for (CommandGroupMetadata aGroup : this.mParser.getMetadata().getCommandGroups()) {
            if (!aGroup.getName().equals(theGroup)) continue;
            for (CommandMetadata aMeta : aGroup.getCommands()) {
                if (aMeta.isHidden()) continue;
                aAvailableCommands.add(aMeta.getName());
            }
        }
        return aAvailableCommands;
    }
}

