/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cli;

import com.complexible.common.inject.OptionalConstructorParam;
import com.complexible.common.util.ServiceLoaders;
import com.complexible.stardog.Environment;
import com.complexible.stardog.cli.CLIBase;
import com.complexible.stardog.cli.CLIBinding;
import com.complexible.stardog.cli.CLIModule;
import com.complexible.stardog.cli.InjectorCommandFactory;
import com.complexible.stardog.cli.impl.Add;
import com.complexible.stardog.cli.impl.DataModel;
import com.complexible.stardog.cli.impl.ExplainQuery;
import com.complexible.stardog.cli.impl.Export;
import com.complexible.stardog.cli.impl.FileCat;
import com.complexible.stardog.cli.impl.FileObfuscate;
import com.complexible.stardog.cli.impl.FileSplit;
import com.complexible.stardog.cli.impl.NamespaceAdd;
import com.complexible.stardog.cli.impl.NamespaceExport;
import com.complexible.stardog.cli.impl.NamespaceImport;
import com.complexible.stardog.cli.impl.NamespaceList;
import com.complexible.stardog.cli.impl.NamespaceRemove;
import com.complexible.stardog.cli.impl.ObfuscateData;
import com.complexible.stardog.cli.impl.ObfuscateQuery;
import com.complexible.stardog.cli.impl.Query;
import com.complexible.stardog.cli.impl.Remove;
import com.complexible.stardog.cli.impl.Size;
import com.complexible.stardog.cli.impl.TestCreate;
import com.complexible.stardog.cli.impl.TestRun;
import com.complexible.stardog.cli.impl.TxBegin;
import com.complexible.stardog.cli.impl.TxCommit;
import com.complexible.stardog.cli.impl.TxList;
import com.complexible.stardog.cli.impl.TxRollback;
import com.complexible.stardog.cli.impl.Version;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.airlift.command.Cli;
import io.airlift.command.Help;
import java.util.Set;

public class CLI
extends CLIBase {
    private static final String STARDOG_SCRIPT = "stardog";
    private static CLI INSTANCE;

    @Inject
    CLI(Injector theInjector, OptionalConstructorParam<Set<CLIBinding>> theCLIBinders) {
        Cli.CliBuilder aBuilder = Cli.builder((String)STARDOG_SCRIPT);
        aBuilder.withCommandFactory(new InjectorCommandFactory(theInjector));
        aBuilder.withDefaultCommand(Help.class);
        aBuilder.withNavOrder(Integer.valueOf(26));
        aBuilder.withDescription("As described in the [Command Line Interface](../operating-stardog/command-line-interface) section of [Operating Stardog](../operating-stardog), Stardog's CLI comes in two parts, `stardog-admin` (the administrative client) and `stardog` (a Stardog user's client). The CLI tools use \u201ccommand groups\u201d to make CLI subcommands easier to find.");
        aBuilder.withCommands(Help.class, new Class[]{Version.class});
        aBuilder.withGroup("data").withDescription("Commands which can modify or dump the contents of a database").withMarkdownDescription("The table below contains the CLI commands for working with data in Stardog.").withCommands(Add.class, new Class[]{Remove.class, Size.class, Export.class, DataModel.class, ObfuscateData.class});
        aBuilder.withGroup("query").withDescription("Commands which query a Stardog database").withMarkdownDescription("Stardog supports the SPARQL query language along with OWL & Rule Reasoning. It supports SPARQL 1.1. Read more about [executing queries](../../query-stardog).").withDefaultCommand(Query.class).withCommands(Query.class, new Class[]{ExplainQuery.class, ObfuscateQuery.class});
        aBuilder.withGroup("test").withDescription("Commands for SPARQL unit tests").withMarkdownDescription("The table below contains the CLI commands to create and run correctness and performance tests.").withCommands(TestCreate.class, new Class[]{TestRun.class});
        aBuilder.withGroup("tx").withDescription("Commands for managing transactions").withMarkdownDescription("The table below contains the CLI commands to manage transactions.").withCommands(TxBegin.class, new Class[]{TxCommit.class, TxList.class, TxRollback.class});
        aBuilder.withGroup("namespace").withDescription("Commands which work with the namespaces defined for a database").withMarkdownDescription("Stardog allows database administrators to persist and manage custom namespace prefix bindings. Read more about namespaces in [Database Administration](../../operating-stardog/database-administration#namespaces).").withCommands(NamespaceAdd.class, new Class[]{NamespaceImport.class, NamespaceExport.class, NamespaceList.class, NamespaceRemove.class});
        aBuilder.withGroup("file").withDescription("Commands for manipulating rdf files").withMarkdownDescription("Stardog provides some CLI commands that work directly over files. For example, you can use the `file cat` command to concatenate multiple RDF files into a single file and `file split` command to split a single RDF file into multiple RDF files. These commands are similar to their *nix counterparts but can handle RDF formats and perform compression/decompression on-the-fly.").withCommands(FileCat.class, new Class[]{FileObfuscate.class, FileSplit.class});
        for (CLIBinding aBinding : (Set)theCLIBinders.or((Object)Sets.newHashSet())) {
            aBinding.bind(aBuilder);
        }
        this.mParser = aBuilder.build();
    }

    public static CLI instance() {
        if (INSTANCE == null) {
            INSTANCE = (CLI)Guice.createInjector((Iterable)ServiceLoaders.instancesOf(CLIModule.class)).getInstance(CLI.class);
        }
        return INSTANCE;
    }

    public static void main(String[] args) throws Exception {
        Environment.assertHome();
        int aExitCode = Math.abs(CLI.instance().execute(args));
        if (aExitCode != 0) {
            System.exit(aExitCode);
        }
    }
}

