/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.util;

import com.github.benmanes.caffeine.cache.Weigher;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.impl.BigDecimalLiteral;
import com.stardog.stark.impl.CalendarLiteral;
import com.stardog.stark.impl.LanguageLiteral;
import com.stardog.stark.impl.TypedLiteral;
import javax.annotation.Nonnull;

public final class ValueWeigher<K>
implements Weigher<K, Value> {
    public static final int OBJECT_OVERHEAD = 8;
    public static final int ENUM_OVERHEAD = 4;
    public static final int REF_OVERHEAD = 8;
    public static final int ARRAY_OVERHEAD = 12;
    public static final int STRING_OVERHEAD = 40;
    public static final int LITERAL_OVERHEAD = 64;
    public static final int TYPED_LITERAL_OVERHEAD = 120;
    public static final int LANG_LITERAL_OVERHEAD = 116;
    public static final int CAL_LITERAL_OVERHEAD = 240;
    public static final int BNODE_OVERHEAD = 56;
    public static final int IRI_OVERHEAD = 60;
    public static final int CAFFEINE_CACHE_ENTRY_OVERHEAD = 88;
    public static final int GUAVA_CACHE_ENTRY_OVERHEAD = 96;
    public final int constantOverhead;

    public ValueWeigher(int keyOverhead) {
        this.constantOverhead = keyOverhead + 96;
    }

    public int weigh(@Nonnull K key, @Nonnull Value value) {
        return this.constantOverhead + ValueWeigher.weightOf(value);
    }

    public static int weightOf(Value value) {
        int mem;
        int lexLen = Value.lexLength(value);
        if (value instanceof IRI) {
            mem = 60 + lexLen * 1;
        } else if (value instanceof BNode) {
            mem = 56 + lexLen * 1;
        } else {
            int charMem = lexLen * 2;
            mem = value instanceof TypedLiteral ? 120 + charMem + ValueWeigher.weightOf(((TypedLiteral)value).datatypeIRI()) : (value instanceof LanguageLiteral ? 116 + charMem + ((Literal)value).lang().get().length() * 2 : (value instanceof CalendarLiteral ? 240 + lexLen * 1 : (value instanceof BigDecimalLiteral ? 64 + lexLen * 1 + 8 + 40 + 4 + 12 : 64 + charMem)));
        }
        return mem;
    }
}

