/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.util;

import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.RDFLists;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.util.ResourceBuilder;
import com.stardog.stark.vocabs.RDF;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GraphBuilder {
    private final Set<Statement> mGraph = new HashSet<Statement>();

    public Set<Statement> graph() {
        return Sets.newHashSet(this.mGraph);
    }

    public void reset() {
        this.mGraph.clear();
    }

    @Nonnull
    public ResourceBuilder iri(@Nonnull IRI theURI) {
        return new ResourceBuilder(this.mGraph, theURI);
    }

    @Nonnull
    public ResourceBuilder iri(@Nonnull String theURI) {
        return this.instance(theURI, null);
    }

    @Nonnull
    public ResourceBuilder instance(@Nonnull IRI theType) {
        return this.instance(Values.bnode(), theType);
    }

    @Nonnull
    public ResourceBuilder instance(@Nonnull Resource theRes, @Nonnull IRI theType) {
        return new ResourceBuilder(this.mGraph, theRes).addType(theType);
    }

    @Nonnull
    public ResourceBuilder instance(@Nullable String theURI, @Nullable IRI theType) {
        Resource aRes;
        Resource resource = aRes = theURI == null ? Values.bnode() : Values.iri(theURI);
        if (theType != null) {
            this.mGraph.add(Values.statement(aRes, RDF.TYPE, theType));
        }
        return new ResourceBuilder(this.mGraph, aRes);
    }

    public ResourceBuilder bnode() {
        return new ResourceBuilder(this.mGraph, Values.bnode());
    }

    @Nonnull
    public ResourceBuilder resource(@Nonnull Resource theRes) {
        return new ResourceBuilder(this.mGraph, theRes);
    }

    @Nonnull
    public Resource list(@Nonnull List<? extends Value> theList) {
        return RDFLists.create(theList, this.mGraph);
    }

    public void add(Statement theStatement) {
        this.mGraph.add(theStatement);
    }
}

