/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.util;

import com.complexible.common.primitives.Bits;
import com.stardog.stark.XMLCalendar;
import com.stardog.stark.impl.CalendarLiteral;
import java.math.BigDecimal;
import javax.xml.datatype.XMLGregorianCalendar;

public final class DateTimeInlineUtils {
    public static final int DATE_LEN = 22;
    public static final int TIME_LEN = 27;
    public static final int MILLI = 0;
    public static final int MILLI_LEN = 16;
    public static final int MINUTES = 16;
    public static final int MINUTES_LEN = 6;
    public static final int HOUR = 22;
    public static final int HOUR_LEN = 5;
    public static final int DAY = 27;
    public static final int DAY_LEN = 5;
    public static final int MONTH = 32;
    public static final int MONTH_LEN = 4;
    public static final int YEAR = 36;
    public static final int YEAR_LEN = 13;
    public static final int MAX_YEARS = 8000;
    public static final int TZ = 49;
    public static final int TZ_LEN = 7;
    public static final int TZ_Z = 127;
    public static final int TZ_NONE = 126;
    public static final int TZ_OFFSET_PRECISION = 15;
    static final BigDecimal MAX_INLINE_FRAC_SECS_PREC = new BigDecimal(".001");
    public static final long NOT_INLINABLE = -1L;

    public static int extractYears(long theLong) {
        return (int)Bits.extractBits((long)theLong, (int)36, (int)49);
    }

    public static int extractMonths(long theLong) {
        int m = (int)Bits.extractBits((long)theLong, (int)32, (int)36);
        return m == 0 ? Integer.MIN_VALUE : m;
    }

    public static int extractDays(long theLong) {
        int d = (int)Bits.extractBits((long)theLong, (int)27, (int)32);
        return d == 0 ? Integer.MIN_VALUE : d;
    }

    public static int extractHours(long theLong) {
        return (int)Bits.extractBits((long)theLong, (int)22, (int)27);
    }

    public static int extractMinutes(long theLong) {
        return (int)Bits.extractBits((long)theLong, (int)16, (int)22);
    }

    public static int extractMillis(long theLong) {
        return (int)Bits.extractBits((long)theLong, (int)0, (int)16);
    }

    public static int extractTimezone(long theLong) {
        int tz = (int)Bits.extractBits((long)theLong, (int)49, (int)56);
        return DateTimeInlineUtils.adjustTZafterExtraction(tz);
    }

    public static int adjustTZafterExtraction(int theTZ) {
        if (theTZ == 126) {
            theTZ = Integer.MIN_VALUE;
        } else if (theTZ == 127) {
            theTZ = 0;
        } else if (Bits.isSet((long)theTZ, (int)6)) {
            theTZ |= 0xFFFFFF80;
            theTZ *= 15;
        } else {
            theTZ *= 15;
        }
        return theTZ;
    }

    private static long time(long theLong, int theHour, int theMins, int theMillisec) {
        theLong = Bits.setBits((long)theLong, (long)theHour, (int)22, (int)27);
        theLong = Bits.setBits((long)theLong, (long)theMins, (int)16, (int)22);
        theLong = Bits.setBits((long)theLong, (long)theMillisec, (int)0, (int)16);
        return theLong;
    }

    private static long date(long theLong, int theYear, int theMonth, int theDay) {
        theLong = Bits.setBits((long)theLong, (long)theYear, (int)36, (int)49);
        theLong = Bits.setBits((long)theLong, (long)theMonth, (int)32, (int)36);
        theLong = Bits.setBits((long)theLong, (long)theDay, (int)27, (int)32);
        return theLong;
    }

    private static long tz(long theLong, int theTZinQuarters) {
        theLong = Bits.setBits((long)theLong, (long)theTZinQuarters, (int)49, (int)56);
        return theLong;
    }

    public static long inline(XMLCalendar aXMLCal, long aInlined) {
        BigDecimal fs;
        if (aXMLCal instanceof CalendarLiteral.Inlined) {
            return ((CalendarLiteral.Inlined)aXMLCal).getInlinedValue();
        }
        XMLGregorianCalendar cal = aXMLCal.unwrap();
        if (cal.getFractionalSecond() != null && !(fs = cal.getFractionalSecond()).remainder(MAX_INLINE_FRAC_SECS_PREC).stripTrailingZeros().equals(BigDecimal.ZERO)) {
            return -1L;
        }
        int y = aXMLCal.getYear();
        if (y < 0 || y >= 8000) {
            return -1L;
        }
        aInlined = DateTimeInlineUtils.date(aInlined, aXMLCal.getYear(), aXMLCal.getMonth(), aXMLCal.getDay());
        aInlined = DateTimeInlineUtils.time(aInlined, aXMLCal.getHour(), aXMLCal.getMinute(), aXMLCal.getSecond() * 1000 + aXMLCal.getMillisecond());
        int tz = aXMLCal.getTimezone();
        if (tz == 0) {
            return DateTimeInlineUtils.tz(aInlined, 127);
        }
        if (tz == Integer.MIN_VALUE) {
            return DateTimeInlineUtils.tz(aInlined, 126);
        }
        if (tz % 15 != 0) {
            return -1L;
        }
        return DateTimeInlineUtils.tz(aInlined, tz /= 15);
    }
}

