/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class StatementImpl
implements Statement {
    @Nonnull
    private final Resource mSubject;
    @Nonnull
    private final IRI mPredicate;
    @Nonnull
    private final Value mObject;
    @Nonnull
    private final Resource mContext;

    public StatementImpl(@Nonnull Resource theSubject, @Nonnull IRI thePredicate, @Nonnull Value theObject, @Nonnull Resource theContext) {
        Preconditions.checkNotNull((Object)theSubject);
        Preconditions.checkNotNull((Object)thePredicate);
        Preconditions.checkNotNull((Object)theObject);
        Preconditions.checkNotNull((Object)theContext);
        this.mSubject = theSubject;
        this.mPredicate = thePredicate;
        this.mObject = theObject;
        this.mContext = theContext;
        if (theObject instanceof Statement || theContext instanceof Statement) {
            throw new IllegalArgumentException("Statements can occur only as subjects of other statements: " + String.valueOf(this));
        }
        if (theSubject instanceof Statement) {
            Statement edge = (Statement)theSubject;
            if (!edge.context().equals(theContext)) {
                throw new IllegalArgumentException("Statement subject should be in the same graph as the outer statement: " + String.valueOf(this));
            }
            if (edge.subject() instanceof Statement) {
                throw new IllegalArgumentException("Nested embedded statements are not supported: " + String.valueOf(this));
            }
        }
    }

    @Override
    @Nonnull
    public Resource context() {
        return this.mContext;
    }

    @Override
    @Nonnull
    public Resource subject() {
        return this.mSubject;
    }

    @Override
    @Nonnull
    public IRI predicate() {
        return this.mPredicate;
    }

    @Override
    @Nonnull
    public Value object() {
        return this.mObject;
    }

    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (!(theObject instanceof StatementImpl)) {
            return false;
        }
        StatementImpl aStmt = (StatementImpl)theObject;
        return Objects.equals(this.mPredicate, aStmt.mPredicate) && Objects.equals(this.mObject, aStmt.mObject) && Objects.equals(this.mSubject, aStmt.mSubject) && Objects.equals(this.mContext, aStmt.mContext);
    }

    public int hashCode() {
        return Objects.hash(this.mSubject, this.mPredicate, this.mObject, this.mContext);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("(");
        if (this.mSubject instanceof Statement) {
            result.append("<< ").append(this.mSubject).append(" >>");
        } else {
            result.append(this.mSubject);
        }
        result.append(" ").append(this.mPredicate);
        result.append(" ").append(this.mObject).append(')');
        if (!this.mContext.equals(Values.DEFAULT_GRAPH)) {
            result.append(" [").append(this.mContext).append("]");
        }
        return result.toString();
    }
}

