/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class ShortLiteral
extends LazyLabelLiteral {
    private final short mShort;

    public ShortLiteral(@Nonnull String theLabel) {
        super(theLabel);
        this.mShort = DatatypeConverter.parseShort((String)theLabel);
    }

    public ShortLiteral(short theShort) {
        this.mShort = theShort;
    }

    public short shortValue() {
        return this.mShort;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.SHORT;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printShort((short)this.mShort);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof ShortLiteral) {
            return ((ShortLiteral)theObject).mShort == this.mShort;
        }
        return super.equals(theObject);
    }
}

