/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.impl.NamespaceImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class NamespacesImpl
implements Namespaces {
    private final Map<String, String> mNamespaces = new HashMap<String, String>();

    public NamespacesImpl() {
    }

    public NamespacesImpl(Iterable<Namespace> theNamespaces) {
        theNamespaces.forEach(ns -> this.mNamespaces.put(ns.prefix(), ns.iri()));
    }

    public static NamespacesImpl defaults() {
        return new NamespacesImpl(Namespaces.DEFAULT);
    }

    @Nonnull
    public NamespacesImpl add(@Nonnull String thePrefix, @Nonnull String theIRI) {
        Preconditions.checkArgument((!thePrefix.contains(":") ? 1 : 0) != 0, (String)"Prefix %s contains an unexpected character, method arguments might be backwards", (Object)thePrefix);
        this.mNamespaces.put(thePrefix, theIRI);
        return this;
    }

    @Nonnull
    public NamespacesImpl add(@Nonnull Namespace theNamespace) {
        return this.add(theNamespace.prefix(), theNamespace.iri());
    }

    @Nonnull
    public NamespacesImpl add(@Nonnull Namespaces theNamespaces) {
        theNamespaces.forEach(this::add);
        return this;
    }

    public boolean contains(@Nonnull String thePrefix) {
        return this.mNamespaces.containsKey(thePrefix);
    }

    @Override
    @Nonnull
    public Optional<String> prefix(@Nonnull String theIRI) {
        return this.mNamespaces.entrySet().stream().filter(es -> ((String)es.getValue()).equals(theIRI)).map(Map.Entry::getKey).findFirst();
    }

    @Override
    @Nonnull
    public Optional<String> iri(@Nonnull String thePrefix) {
        return Optional.ofNullable(this.mNamespaces.get(thePrefix));
    }

    @Override
    public Iterator<Namespace> iterator() {
        return this.mNamespaces.entrySet().stream().map((? super T e) -> new NamespaceImpl((String)e.getKey(), (String)e.getValue())).iterator();
    }

    public int size() {
        return this.mNamespaces.size();
    }
}

