/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class LongLiteral
extends LazyLabelLiteral {
    private final long mValue;

    public LongLiteral(@Nonnull String theLabel) {
        super(theLabel);
        this.mValue = DatatypeConverter.parseLong((String)theLabel);
    }

    public LongLiteral(long theValue) {
        this.mValue = theValue;
    }

    public long longValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.LONG;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printLong((long)this.mValue);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof LongLiteral) {
            return ((LongLiteral)theObject).mValue == this.mValue;
        }
        return super.equals(theObject);
    }
}

