/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.Literal;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class LazyLabelLiteral
implements Literal {
    private String mLabel;

    protected LazyLabelLiteral() {
        this.mLabel = null;
    }

    protected LazyLabelLiteral(@Nonnull String theLabel) {
        this.mLabel = (String)Preconditions.checkNotNull((Object)theLabel, (Object)"label should never be null");
    }

    @Override
    @Nonnull
    public final String label() {
        if (this.mLabel == null) {
            this.mLabel = this.computeLabel();
        }
        return this.mLabel;
    }

    public final String toString() {
        return Literal.str(this);
    }

    public boolean equals(Object theObject) {
        if (theObject instanceof Literal) {
            Literal aLiteral = (Literal)theObject;
            return Datatype.datatypesEqual(this, aLiteral) && this.label().equals(aLiteral.label());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label(), this.datatype(), this.datatypeIRI()});
    }

    protected abstract String computeLabel();
}

