/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.impl.AbstractLiteral;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class LanguageLiteral
extends AbstractLiteral {
    private final Optional<String> mLang;

    public LanguageLiteral(@Nonnull String theLabel, @Nonnull String theLang) {
        super(theLabel);
        this.mLang = Optional.of((String)Preconditions.checkNotNull((Object)theLang, (Object)"language tag cannot be null"));
    }

    @Override
    @Nonnull
    public Optional<String> lang() {
        return this.mLang;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.LANG_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mLabel);
    }

    @Override
    public boolean equals(Object theObject) {
        if (theObject == null) {
            return false;
        }
        if (theObject == this) {
            return true;
        }
        if (theObject instanceof LanguageLiteral) {
            LanguageLiteral aLit = (LanguageLiteral)theObject;
            return this.mLabel.equals(aLit.mLabel) && this.mLang.get().equalsIgnoreCase(aLit.mLang.get());
        }
        return false;
    }
}

