/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class IntegerLiteral
extends LazyLabelLiteral {
    private final int mValue;

    public IntegerLiteral(String theLabel) {
        super(theLabel);
        this.mValue = DatatypeConverter.parseInt((String)theLabel);
    }

    public IntegerLiteral(int theValue) {
        this.mValue = theValue;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.INTEGER;
    }

    public int intValue() {
        return this.mValue;
    }

    @Override
    protected String computeLabel() {
        return String.valueOf(this.mValue);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof IntegerLiteral) {
            return ((IntegerLiteral)theObject).mValue == this.mValue;
        }
        return super.equals(theObject);
    }
}

