/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class IntLiteral
extends LazyLabelLiteral {
    private final int mValue;

    public IntLiteral(String theLabel) {
        super(theLabel);
        this.mValue = DatatypeConverter.parseInt((String)theLabel);
    }

    public IntLiteral(int theValue) {
        this.mValue = theValue;
    }

    public int intValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.INT;
    }

    @Override
    protected String computeLabel() {
        return String.valueOf(this.mValue);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof IntLiteral) {
            return ((IntLiteral)theObject).mValue == this.mValue;
        }
        return super.equals(theObject);
    }
}

