/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.collect.ImmutableSet;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.impl.NamespaceImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ImmutableNamespaces
implements Namespaces {
    private static final Namespaces EMPTY = new ImmutableNamespaces((Iterable<Namespace>)ImmutableSet.of());
    private final Collection<Namespace> mNamespaces;

    public ImmutableNamespaces(Namespace ... theNamespaces) {
        this.mNamespaces = ImmutableSet.copyOf((Object[])theNamespaces);
    }

    public ImmutableNamespaces(Iterable<Namespace> theNamespaces) {
        this.mNamespaces = ImmutableSet.copyOf(theNamespaces);
    }

    @Nonnull
    public static ImmutableNamespaces of(@Nonnull String thePrefix, @Nonnull String theIRI) {
        return new ImmutableNamespaces(new NamespaceImpl(thePrefix, theIRI));
    }

    @Nonnull
    public static ImmutableNamespaces of(@Nonnull Iterable<Namespace> theNamespaces, Iterable<Namespace> ... theOtherNamespaces) {
        ImmutableSet.Builder aBuilder = ImmutableSet.builder().addAll(theNamespaces);
        Stream.of(theOtherNamespaces).forEach(arg_0 -> ((ImmutableSet.Builder)aBuilder).addAll(arg_0));
        return new ImmutableNamespaces((Iterable<Namespace>)aBuilder.build());
    }

    @Nonnull
    public static ImmutableNamespaces of(@Nonnull Map<String, String> theNamespaces) {
        ImmutableSet.Builder aBuilder = ImmutableSet.builder();
        theNamespaces.entrySet().stream().map((? super T e) -> new NamespaceImpl((String)e.getKey(), (String)e.getValue())).forEach(arg_0 -> ((ImmutableSet.Builder)aBuilder).add(arg_0));
        return new ImmutableNamespaces((Iterable<Namespace>)aBuilder.build());
    }

    @Nonnull
    public static ImmutableNamespaces of(@Nonnull Iterable<Namespace> theNamespaces) {
        return new ImmutableNamespaces((Iterable<Namespace>)ImmutableSet.copyOf(theNamespaces));
    }

    @Nonnull
    public static Namespaces empty() {
        return EMPTY;
    }

    @Override
    @Nonnull
    public Iterator<Namespace> iterator() {
        return this.mNamespaces.iterator();
    }

    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject == null || this.getClass() != theObject.getClass()) {
            return false;
        }
        ImmutableNamespaces aNamespaces = (ImmutableNamespaces)theObject;
        return Objects.equals(this.mNamespaces, aNamespaces.mNamespaces);
    }

    public int hashCode() {
        return Objects.hashCode(this.mNamespaces);
    }
}

