/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.IRI;
import javax.annotation.Nonnull;

public final class IRIImpl
implements IRI {
    private static final boolean RELATIVE_URI = System.getProperty("stark.relative_uri", "false").equalsIgnoreCase("true");
    private static final long serialVersionUID = 8492682135904384990L;
    private final String mURI;
    private final int mIndex;

    public IRIImpl(@Nonnull String theURI) {
        this.mURI = ((String)Preconditions.checkNotNull((Object)theURI, (Object)"URI string must be != null in IRIImpl")).trim();
        this.mIndex = IRIImpl.getLocalNameIndex(this.mURI);
    }

    public IRIImpl(@Nonnull String nameSpace, String localName) {
        Preconditions.checkNotNull((Object)nameSpace, (Object)"namespace part must be supplied for IRI");
        Preconditions.checkNotNull((Object)localName, (Object)"local name part must be supplied for IRI");
        this.mURI = nameSpace + localName;
        this.mIndex = nameSpace.length();
    }

    public static int getLocalNameIndex(@Nonnull String uri) {
        int separatorIdx = uri.indexOf(35);
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(47);
        }
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(58);
        }
        if (separatorIdx < 0 && !RELATIVE_URI) {
            throw new IllegalArgumentException("No separator character found in the URI: " + uri);
        }
        return separatorIdx + 1;
    }

    @Override
    @Nonnull
    public String namespace() {
        return this.mURI.substring(0, this.mIndex);
    }

    @Override
    @Nonnull
    public String localName() {
        return this.mURI.substring(this.mIndex);
    }

    public int hashCode() {
        return this.mURI.hashCode();
    }

    public boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof IRIImpl) {
            IRIImpl aURI = (IRIImpl)theObj;
            return this.mIndex == aURI.mIndex && this.mURI.equals(aURI.mURI);
        }
        if (theObj instanceof IRI) {
            return ((IRI)theObj).toString().equals(this.mURI);
        }
        return false;
    }

    public String toString() {
        return this.mURI;
    }
}

