/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class GenericLongLiteral
extends LazyLabelLiteral {
    private final long mValue;
    private final Datatype mType;

    public GenericLongLiteral(@Nonnull String theLabel, @Nonnull Datatype theType) {
        super(theLabel);
        this.mType = theType;
        this.mValue = DatatypeConverter.parseInt((String)theLabel);
    }

    public GenericLongLiteral(long theValue, @Nonnull Datatype theType) {
        this.mValue = theValue;
        this.mType = theType;
    }

    public long longValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return this.mType;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printLong((long)this.mValue);
    }

    @Override
    public boolean equals(Object theObject) {
        GenericLongLiteral other;
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof GenericLongLiteral && (other = (GenericLongLiteral)theObject).datatype() == this.mType) {
            return other.mValue == this.mValue;
        }
        return super.equals(theObject);
    }
}

