/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class GenericIntegerLiteral
extends LazyLabelLiteral {
    private final int mInt;
    private final Datatype mType;

    public GenericIntegerLiteral(@Nonnull String theLabel, @Nonnull Datatype theType) {
        super(theLabel);
        Preconditions.checkNotNull((Object)((Object)theType));
        this.mType = theType;
        this.mInt = DatatypeConverter.parseInt((String)theLabel);
    }

    public GenericIntegerLiteral(int theInt, @Nonnull Datatype theType) {
        Preconditions.checkNotNull((Object)((Object)theType));
        this.mInt = theInt;
        this.mType = theType;
    }

    public int intValue() {
        return this.mInt;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return this.mType;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printInt((int)this.mInt);
    }

    @Override
    public boolean equals(Object theObject) {
        GenericIntegerLiteral other;
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof GenericIntegerLiteral && (other = (GenericIntegerLiteral)theObject).datatype() == this.mType) {
            return other.mInt == this.mInt;
        }
        return super.equals(theObject);
    }
}

