/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class FloatLiteral
extends LazyLabelLiteral {
    private final float mValue;

    public FloatLiteral(@Nonnull String theLabel) {
        super(theLabel);
        this.mValue = DatatypeConverter.parseFloat((String)theLabel);
    }

    public FloatLiteral(float theValue) {
        this.mValue = theValue;
    }

    public float floatValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.FLOAT;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printFloat((float)this.mValue);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof FloatLiteral) {
            FloatLiteral other = (FloatLiteral)theObject;
            return other.mValue == this.mValue;
        }
        return super.equals(theObject);
    }
}

