/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class DoubleLiteral
extends LazyLabelLiteral {
    private final double mDouble;

    public DoubleLiteral(double theDouble) {
        this.mDouble = theDouble;
    }

    public DoubleLiteral(String theLabel) {
        super(theLabel);
        this.mDouble = DatatypeConverter.parseDouble((String)theLabel);
    }

    public double doubleValue() {
        return this.mDouble;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.DOUBLE;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printDouble((double)this.mDouble);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof DoubleLiteral) {
            return ((DoubleLiteral)theObject).mDouble == this.mDouble;
        }
        return super.equals(theObject);
    }
}

