/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.Literal;
import com.stardog.stark.Values;
import com.stardog.stark.XMLCalendar;
import com.stardog.stark.util.DateTimeInlineUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.datatype.XMLGregorianCalendar;

public class CalendarLiteral
implements Literal,
XMLCalendar {
    protected final Datatype mDatatype;
    protected XMLGregorianCalendar mCalendar;
    private String mCalendarLabel;

    public CalendarLiteral(@Nonnull XMLGregorianCalendar theCalendar, @Nonnull Datatype theDatatype) {
        this.mCalendar = (XMLGregorianCalendar)Preconditions.checkNotNull((Object)theCalendar, (Object)"calendar value must be != null");
        this.mDatatype = (Datatype)((Object)Preconditions.checkNotNull((Object)((Object)theDatatype), (Object)"calendar type must be != null"));
    }

    protected CalendarLiteral(@Nonnull Datatype theDatatype) {
        this.mCalendar = null;
        this.mDatatype = theDatatype;
    }

    @Override
    public XMLGregorianCalendar unwrap() {
        return this.mCalendar;
    }

    @Override
    @Nonnull
    public String label() {
        if (this.mCalendarLabel == null) {
            this.mCalendarLabel = this.toXMLFormat();
        }
        return this.mCalendarLabel;
    }

    public String toString() {
        return Literal.str(this);
    }

    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof XMLCalendar) {
            XMLCalendar cal = (XMLCalendar)theObject;
            return this.compare(cal) == 0;
        }
        if (theObject instanceof Literal) {
            Literal aLiteral = (Literal)theObject;
            return Datatype.datatypesEqual(this, aLiteral) && this.label().equals(aLiteral.label());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label(), this.datatype(), this.datatypeIRI()});
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return this.mDatatype;
    }

    @Override
    public BigInteger getEon() {
        return this.mCalendar.getEon();
    }

    @Override
    public int getYear() {
        return this.mCalendar.getYear();
    }

    @Override
    public int getMonth() {
        return this.mCalendar.getMonth();
    }

    @Override
    public int getDay() {
        return this.mCalendar.getDay();
    }

    @Override
    public int getHour() {
        return this.mCalendar.getHour();
    }

    @Override
    public int getMinute() {
        return this.mCalendar.getMinute();
    }

    @Override
    public int getSecond() {
        return this.mCalendar.getSecond();
    }

    @Override
    public int getMillisecond() {
        return this.mCalendar.getMillisecond();
    }

    @Override
    public BigDecimal getFractionalSecond() {
        return this.mCalendar.getFractionalSecond();
    }

    @Override
    public int getTimezone() {
        return this.mCalendar.getTimezone();
    }

    @Override
    public int compare(XMLCalendar r) {
        if (this.getTimezone() != r.getTimezone()) {
            return this.unwrap().compare(r.unwrap());
        }
        return CalendarLiteral.compareCalendarSameTZ(this, r);
    }

    private static int compareField(int a, int b) {
        if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
            return 2;
        }
        return a < b ? -1 : 1;
    }

    private static int compareField(BigDecimal l, BigDecimal r) {
        if (l == r) {
            return 0;
        }
        if (l == null) {
            l = BigDecimal.ZERO;
        }
        if (r == null) {
            r = BigDecimal.ZERO;
        }
        return l.compareTo(r);
    }

    public static int compareCalendarSameTZ(XMLCalendar l, XMLCalendar r) {
        int rv;
        int lv;
        assert (l.getTimezone() == r.getTimezone());
        if (l.getEon() == null && r.getEon() == null) {
            lv = l.getYear();
            if (lv != (rv = r.getYear())) {
                return CalendarLiteral.compareField(lv, rv);
            }
        } else {
            return l.getEon() != null ? -1 : 1;
        }
        lv = l.getMonth();
        if (lv != (rv = r.getMonth())) {
            return CalendarLiteral.compareField(lv, rv);
        }
        lv = l.getDay();
        if (lv != (rv = r.getDay())) {
            return CalendarLiteral.compareField(lv, rv);
        }
        lv = l.getHour();
        if (lv != (rv = r.getHour())) {
            return CalendarLiteral.compareField(lv, rv);
        }
        lv = l.getMinute();
        if (lv != (rv = r.getMinute())) {
            return CalendarLiteral.compareField(lv, rv);
        }
        lv = l.getSecond();
        if (lv != (rv = r.getSecond())) {
            return CalendarLiteral.compareField(lv, rv);
        }
        if (!(l instanceof Inlined) || !(r instanceof Inlined)) {
            return CalendarLiteral.compareField(l.getFractionalSecond(), r.getFractionalSecond());
        }
        lv = l.getMillisecond();
        if (lv != (rv = r.getMillisecond())) {
            return CalendarLiteral.compareField(lv, rv);
        }
        return 0;
    }

    @Override
    public String toXMLFormat() {
        int day;
        int month;
        String formatString = null;
        int year = this.getYear();
        int mask = (year != Integer.MIN_VALUE ? 32 : 0) | ((month = this.getMonth()) != Integer.MIN_VALUE ? 16 : 0) | ((day = this.getDay()) != Integer.MIN_VALUE ? 8 : 0) | (this.getHour() != Integer.MIN_VALUE ? 4 : 0) | (this.getMinute() != Integer.MIN_VALUE ? 2 : 0) | (this.getSecond() != Integer.MIN_VALUE ? 1 : 0);
        if (mask == 63) {
            formatString = "%Y-%M-%DT%h:%m:%s%z";
        } else if (mask == 56) {
            formatString = "%Y-%M-%D%z";
        } else if (mask == 7) {
            formatString = "%h:%m:%s%z";
        } else if (mask == 16) {
            formatString = "--%M--%z";
        } else if (mask == 8) {
            formatString = "---%D%z";
        } else if (mask == 32) {
            formatString = "%Y%z";
        } else if (mask == 48) {
            formatString = "%Y-%M%z";
        } else if (mask == 24) {
            formatString = "--%M-%D%z";
        } else if ((mask & 0xF8) == 48) {
            formatString = "%Y-%M%z";
        } else if ((mask & 0xF8) == 32) {
            formatString = "%Y%z";
        } else if ((mask & 0xF8) == 24) {
            formatString = "--%M-%D%z";
        } else if ((mask & 0xF8) == 16) {
            formatString = "--%M--%z";
        } else if ((mask & 0xF8) == 8) {
            formatString = "---%D%z";
        }
        if (formatString == null) {
            throw new IllegalStateException("Invalid set of fields set for an xsd:date or xsd:dateTime literal");
        }
        return this.format(formatString);
    }

    private String format(String format) {
        StringBuilder buf = new StringBuilder();
        int fidx = 0;
        int flen = format.length();
        block9: while (fidx < flen) {
            char fch;
            if ((fch = format.charAt(fidx++)) != '%') {
                buf.append(fch);
                continue;
            }
            switch (format.charAt(fidx++)) {
                case 'Y': {
                    if (this.getEon() == null) {
                        int absYear = this.getYear();
                        if (absYear < 0) {
                            buf.append('-');
                            absYear = -this.getYear();
                        }
                        CalendarLiteral.printNumber(buf, absYear, 4);
                        continue block9;
                    }
                    BigInteger eonAndYear = this.getEon().add(BigInteger.valueOf(this.getYear()));
                    CalendarLiteral.printNumber(buf, eonAndYear, 4);
                    continue block9;
                }
                case 'M': {
                    CalendarLiteral.printNumber(buf, this.getMonth(), 2);
                    continue block9;
                }
                case 'D': {
                    CalendarLiteral.printNumber(buf, this.getDay(), 2);
                    continue block9;
                }
                case 'h': {
                    CalendarLiteral.printNumber(buf, this.getHour(), 2);
                    continue block9;
                }
                case 'm': {
                    CalendarLiteral.printNumber(buf, this.getMinute(), 2);
                    continue block9;
                }
                case 's': {
                    CalendarLiteral.printNumber(buf, this.getSecond(), 2);
                    if (this instanceof Inlined) {
                        if (this.getMillisecond() <= 0) continue block9;
                        buf.append(".");
                        CalendarLiteral.printNumber(buf, this.getMillisecond(), 3);
                        continue block9;
                    }
                    if (this.getFractionalSecond() == null) continue block9;
                    String frac = this.getFractionalSecond().toPlainString();
                    buf.append(frac.substring(1));
                    continue block9;
                }
                case 'z': {
                    int offset = this.getTimezone();
                    if (offset == 0) {
                        buf.append('Z');
                        continue block9;
                    }
                    if (offset == Integer.MIN_VALUE) continue block9;
                    if (offset < 0) {
                        buf.append('-');
                        offset *= -1;
                    } else {
                        buf.append('+');
                    }
                    CalendarLiteral.printNumber(buf, offset / 60, 2);
                    buf.append(':');
                    CalendarLiteral.printNumber(buf, offset % 60, 2);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return buf.toString();
    }

    private static void printNumber(StringBuilder out, int number, int nDigits) {
        String s = String.valueOf(number);
        out.append("0".repeat(Math.max(0, nDigits - s.length())));
        out.append(s);
    }

    private static void printNumber(StringBuilder out, BigInteger number, int nDigits) {
        String s = number.toString();
        out.append("0".repeat(Math.max(0, nDigits - s.length())));
        out.append(s);
    }

    public static class Inlined
    extends CalendarLiteral {
        private final long mInlinedValue;

        public Inlined(long theInlinedValue, @Nonnull Datatype theDatatype) {
            super(theDatatype);
            assert (theDatatype == Datatype.DATE || theDatatype == Datatype.DATETIME);
            this.mInlinedValue = theInlinedValue;
        }

        public long getInlinedValue() {
            return this.mInlinedValue;
        }

        @Override
        public XMLGregorianCalendar unwrap() {
            if (this.mCalendar == null) {
                if (this.mDatatype == Datatype.DATE) {
                    this.mCalendar = Values.DATATYPE_FACTORY.newXMLGregorianCalendarDate(this.getYear(), this.getMonth(), this.getDay(), this.getTimezone());
                } else {
                    int milliSeconds = DateTimeInlineUtils.extractMillis(this.mInlinedValue);
                    int fractionSec = milliSeconds % 1000;
                    int fs = fractionSec == 0 ? Integer.MIN_VALUE : fractionSec;
                    this.mCalendar = Values.DATATYPE_FACTORY.newXMLGregorianCalendar(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), milliSeconds / 1000, fs, this.getTimezone());
                }
            }
            return this.mCalendar;
        }

        @Override
        public BigInteger getEon() {
            return null;
        }

        @Override
        public int getYear() {
            return DateTimeInlineUtils.extractYears(this.mInlinedValue);
        }

        @Override
        public int getMonth() {
            return DateTimeInlineUtils.extractMonths(this.mInlinedValue);
        }

        @Override
        public int getDay() {
            return DateTimeInlineUtils.extractDays(this.mInlinedValue);
        }

        @Override
        public int getHour() {
            if (this.mDatatype == Datatype.DATE) {
                return Integer.MIN_VALUE;
            }
            return DateTimeInlineUtils.extractHours(this.mInlinedValue);
        }

        @Override
        public int getMinute() {
            if (this.mDatatype == Datatype.DATE) {
                return Integer.MIN_VALUE;
            }
            return DateTimeInlineUtils.extractMinutes(this.mInlinedValue);
        }

        @Override
        public int getSecond() {
            if (this.mDatatype == Datatype.DATE) {
                return Integer.MIN_VALUE;
            }
            return DateTimeInlineUtils.extractMillis(this.mInlinedValue) / 1000;
        }

        @Override
        public int getMillisecond() {
            if (this.mDatatype == Datatype.DATE) {
                return Integer.MIN_VALUE;
            }
            return DateTimeInlineUtils.extractMillis(this.mInlinedValue) % 1000;
        }

        @Override
        public BigDecimal getFractionalSecond() {
            int milli = this.getMillisecond();
            if (milli == Integer.MIN_VALUE) {
                return null;
            }
            if (milli == 0) {
                return BigDecimal.ZERO;
            }
            return BigDecimal.valueOf(milli, 3);
        }

        @Override
        public int getTimezone() {
            return DateTimeInlineUtils.extractTimezone(this.mInlinedValue);
        }

        @Override
        public int compare(XMLCalendar r) {
            if (this.getTimezone() != r.getTimezone()) {
                return this.unwrap().compare(r.unwrap());
            }
            if (r instanceof Inlined) {
                return Long.compare(this.mInlinedValue, ((Inlined)r).mInlinedValue);
            }
            return Inlined.compareCalendarSameTZ(this, r);
        }
    }
}

