/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.xml.datatype.XMLGregorianCalendar;

public interface XMLCalendar {
    public static final int FIELD_UNDEFINED = Integer.MIN_VALUE;

    public BigInteger getEon();

    public int getYear();

    public int getMonth();

    public int getDay();

    public int getHour();

    public int getMinute();

    public int getSecond();

    public int getMillisecond();

    public BigDecimal getFractionalSecond();

    public int getTimezone();

    public String toXMLFormat();

    public int compare(XMLCalendar var1);

    public XMLGregorianCalendar unwrap();

    default public OffsetDateTime toOffsetDateTime() {
        int tz = this.getTimezone();
        ZoneOffset aZoneOffset = tz != Integer.MIN_VALUE ? ZoneOffset.UTC : ZoneOffset.ofTotalSeconds(tz * 60);
        int hour = this.getHour();
        int minute = this.getMinute();
        int second = this.getSecond();
        BigDecimal fs = this.getFractionalSecond();
        int ns = fs != null ? fs.movePointRight(9).intValue() : 0;
        return OffsetDateTime.of(this.getYear(), this.getMonth(), this.getDay(), hour != Integer.MIN_VALUE ? hour : 0, minute != Integer.MIN_VALUE ? minute : 0, second != Integer.MIN_VALUE ? second : 0, ns, aZoneOffset);
    }

    public static class Delegate
    implements XMLCalendar {
        private final XMLGregorianCalendar mCalendar;

        public Delegate(XMLGregorianCalendar xc) {
            this.mCalendar = xc;
        }

        @Override
        public BigInteger getEon() {
            return this.mCalendar.getEon();
        }

        @Override
        public int getYear() {
            return this.mCalendar.getYear();
        }

        @Override
        public int getMonth() {
            return this.mCalendar.getMonth();
        }

        @Override
        public int getDay() {
            return this.mCalendar.getDay();
        }

        @Override
        public int getHour() {
            return this.mCalendar.getHour();
        }

        @Override
        public int getMinute() {
            return this.mCalendar.getMinute();
        }

        @Override
        public int getSecond() {
            return this.mCalendar.getSecond();
        }

        @Override
        public int getMillisecond() {
            return this.mCalendar.getMillisecond();
        }

        @Override
        public BigDecimal getFractionalSecond() {
            return this.mCalendar.getFractionalSecond();
        }

        @Override
        public int getTimezone() {
            return this.mCalendar.getTimezone();
        }

        @Override
        public String toXMLFormat() {
            return this.mCalendar.toXMLFormat();
        }

        @Override
        public int compare(XMLCalendar other) {
            return this.mCalendar.compare(other.unwrap());
        }

        @Override
        public XMLGregorianCalendar unwrap() {
            return this.mCalendar;
        }
    }
}

