/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.impl.BNodeImpl;
import com.stardog.stark.impl.BigDecimalLiteral;
import com.stardog.stark.impl.BigIntegerLiteral;
import com.stardog.stark.impl.BooleanLiteral;
import com.stardog.stark.impl.ByteLiteral;
import com.stardog.stark.impl.CalendarLiteral;
import com.stardog.stark.impl.DoubleLiteral;
import com.stardog.stark.impl.DurationLiteral;
import com.stardog.stark.impl.FloatLiteral;
import com.stardog.stark.impl.GenericIntegerLiteral;
import com.stardog.stark.impl.GenericLongLiteral;
import com.stardog.stark.impl.IRIImpl;
import com.stardog.stark.impl.IntLiteral;
import com.stardog.stark.impl.IntegerLiteral;
import com.stardog.stark.impl.LanguageLiteral;
import com.stardog.stark.impl.LongIntegerLiteral;
import com.stardog.stark.impl.LongLiteral;
import com.stardog.stark.impl.NamespaceImpl;
import com.stardog.stark.impl.ShortLiteral;
import com.stardog.stark.impl.StatementImpl;
import com.stardog.stark.impl.StringLiteral;
import com.stardog.stark.impl.TypedLiteral;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Values {
    private static final Logger LOGGER = LoggerFactory.getLogger(Values.class);
    private static final Pattern RFC3066 = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
    private static final CharMatcher IRI_SYNTAX_REGEX = CharMatcher.anyOf((CharSequence)"{}<>").precomputed();
    public static final IRI DEFAULT_GRAPH = Values.iri("tag:stardog:api:context:default");
    public static final IRI LOCAL_GRAPHS = Values.iri("tag:stardog:api:context:local");
    public static final IRI NAMED_GRAPHS = Values.iri("tag:stardog:api:context:named");
    public static final IRI ALL_GRAPHS = Values.iri("tag:stardog:api:context:all");
    public static final IRI VIRTUAL_GRAPHS = Values.iri("tag:stardog:api:context:virtual");
    private static final String BNODE_PREFIX_BASE = "bnode";
    private static final char BNODE_SEP = '_';
    private static final AtomicLong NEXT_BNODE_ID = new AtomicLong(1L);
    private static final String BNODE_PREFIX = "bnode_" + UUID.randomUUID().toString().replace('-', '_') + "_";
    public static final DatatypeFactory DATATYPE_FACTORY;
    public static final String VIRTUAL_NAMESPACE = "virtual://";

    private Values() {
        throw new AssertionError();
    }

    @Nonnull
    public static Namespace namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        return new NamespaceImpl(thePrefix, theIRI);
    }

    @Nonnull
    public static IRI iri(@Nonnull String theNS, @Nonnull String theLocalName) {
        Preconditions.checkNotNull((Object)theNS);
        Preconditions.checkNotNull((Object)theLocalName);
        return new IRIImpl(theNS + theLocalName);
    }

    @Nonnull
    public static IRI iri(@Nonnull String theIRI) {
        Preconditions.checkNotNull((Object)theIRI);
        return new IRIImpl(theIRI);
    }

    public static IRI uniqueIri(String prefix) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkArgument((prefix.length() > 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((prefix.charAt(0) != ':' ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)prefix.contains(":"));
        return Values.iri(prefix + UUID.randomUUID().toString().replace('-', '_'));
    }

    @Nonnull
    public static BNode bnode() {
        return Values.bnode(BNODE_PREFIX + NEXT_BNODE_ID.getAndIncrement());
    }

    @Nonnull
    public static BNode bnode(@Nonnull String theId) {
        Preconditions.checkNotNull((Object)theId);
        return new BNodeImpl(theId);
    }

    @Nonnull
    public static Literal literal(@Nonnull String theLabel) {
        Preconditions.checkNotNull((Object)theLabel);
        return new StringLiteral(theLabel);
    }

    @Nonnull
    public static Literal literal(boolean theValue) {
        return BooleanLiteral.create(theValue);
    }

    @Nonnull
    public static Literal literal(int theValue) {
        return new IntLiteral(theValue);
    }

    @Nonnull
    public static Literal literal(long theValue) {
        return new LongLiteral(theValue);
    }

    @Nonnull
    public static Literal literal(float theValue) {
        return new FloatLiteral(theValue);
    }

    @Nonnull
    public static Literal literal(double theValue) {
        return new DoubleLiteral(theValue);
    }

    @Nonnull
    public static Literal literal(short theValue) {
        return new ShortLiteral(theValue);
    }

    @Nonnull
    public static Literal literal(byte theValue) {
        return new ByteLiteral(theValue);
    }

    @Nonnull
    public static Literal literal(@Nonnull String theLabel, @Nonnull IRI theDatatype) {
        Preconditions.checkNotNull((Object)theLabel);
        Preconditions.checkNotNull((Object)theDatatype);
        Datatype aDatatype = Datatype.of(theDatatype);
        if (aDatatype == Datatype.UDF) {
            return new TypedLiteral(theLabel, theDatatype, aDatatype);
        }
        return Values.literal(theLabel, aDatatype);
    }

    @Nonnull
    public static Literal literal(@Nonnull String theLabel, @Nonnull String theLanguage) {
        Preconditions.checkNotNull((Object)theLabel);
        Preconditions.checkNotNull((Object)theLanguage);
        return new LanguageLiteral(theLabel, theLanguage);
    }

    @Nonnull
    public static Literal literal(int theLabel, @Nonnull Datatype theDatatype) {
        switch (theDatatype) {
            case INT: {
                return new IntLiteral(theLabel);
            }
            case INTEGER: {
                return new IntegerLiteral(theLabel);
            }
            case LONG: {
                return new LongLiteral(theLabel);
            }
        }
        return new GenericIntegerLiteral(theLabel, theDatatype);
    }

    @Nonnull
    public static Literal literal(long theLabel, @Nonnull Datatype theDatatype) {
        switch (theDatatype) {
            case INTEGER: {
                return new LongIntegerLiteral(theLabel);
            }
            case LONG: {
                return new LongLiteral(theLabel);
            }
        }
        return new GenericLongLiteral(theLabel, theDatatype);
    }

    @Nonnull
    public static Literal literal(@Nonnull Number theNumber) {
        Preconditions.checkNotNull((Object)theNumber);
        if (theNumber instanceof Integer) {
            return new IntLiteral((Integer)theNumber);
        }
        if (theNumber instanceof Long) {
            return new LongLiteral((Long)theNumber);
        }
        if (theNumber instanceof Short) {
            return new ShortLiteral((Short)theNumber);
        }
        if (theNumber instanceof Byte) {
            return new ByteLiteral((Byte)theNumber);
        }
        if (theNumber instanceof Double) {
            return new DoubleLiteral((Double)theNumber);
        }
        if (theNumber instanceof Float) {
            return new FloatLiteral(((Float)theNumber).floatValue());
        }
        if (theNumber instanceof BigDecimal) {
            return new BigDecimalLiteral((BigDecimal)theNumber);
        }
        if (theNumber instanceof BigInteger) {
            return new BigIntegerLiteral((BigInteger)theNumber);
        }
        throw new IllegalArgumentException();
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public static Literal literal(@Nonnull String theLabel, @Nonnull Datatype theDatatype) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public static Literal literal(@Nonnull Date theDate) {
        Preconditions.checkNotNull((Object)theDate);
        GregorianCalendar aCal = new GregorianCalendar();
        aCal.setTime(theDate);
        return Values.literal(DATATYPE_FACTORY.newXMLGregorianCalendar(aCal));
    }

    @Nonnull
    public static Literal literal(@Nonnull GregorianCalendar theDate) {
        Preconditions.checkNotNull((Object)theDate);
        return Values.literal(DATATYPE_FACTORY.newXMLGregorianCalendar(theDate));
    }

    @Nonnull
    public static Literal literal(@Nonnull Duration theDuration) {
        Preconditions.checkNotNull((Object)theDuration);
        return new DurationLiteral(theDuration, Datatype.DURATION);
    }

    @Nonnull
    public static Literal literal(@Nonnull Duration theDuration, @Nonnull IRI theDurationType) {
        Preconditions.checkNotNull((Object)theDuration);
        Preconditions.checkNotNull((Object)theDurationType);
        return new DurationLiteral(theDuration, Datatype.of(theDurationType));
    }

    @Nonnull
    public static Literal literal(@Nonnull XMLGregorianCalendar theCalendar) {
        Preconditions.checkNotNull((Object)theCalendar);
        QName qname = theCalendar.getXMLSchemaType();
        if (DatatypeConstants.DATETIME.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.DATETIME);
        }
        if (DatatypeConstants.DATE.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.DATE);
        }
        if (DatatypeConstants.TIME.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.TIME);
        }
        if (DatatypeConstants.GYEARMONTH.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.GYEARMONTH);
        }
        if (DatatypeConstants.GMONTHDAY.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.GMONTHDAY);
        }
        if (DatatypeConstants.GYEAR.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.GYEAR);
        }
        if (DatatypeConstants.GMONTH.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.GMONTH);
        }
        if (DatatypeConstants.GDAY.equals(qname)) {
            return new CalendarLiteral(theCalendar, Datatype.GDAY);
        }
        throw new IllegalArgumentException("QName cannot be mapped to an XML Schema URI: " + qname.toString());
    }

    @Nonnull
    public static Literal literal(@Nonnull XMLGregorianCalendar theCalendar, @Nonnull Datatype theDatatype) {
        Preconditions.checkNotNull((Object)theCalendar);
        Preconditions.checkNotNull((Object)((Object)theDatatype));
        return new CalendarLiteral(theCalendar, theDatatype);
    }

    @Nonnull
    public static Literal literal(@Nonnull Duration theDuration, @Nonnull Datatype theDatatype) {
        Preconditions.checkNotNull((Object)theDuration);
        Preconditions.checkNotNull((Object)((Object)theDatatype));
        return new DurationLiteral(theDuration, theDatatype);
    }

    @Nonnull
    public static Literal literal(@Nonnull BigDecimal theBigDecimal) {
        Preconditions.checkNotNull((Object)theBigDecimal);
        return new BigDecimalLiteral(theBigDecimal);
    }

    @Nonnull
    public static Literal literal(@Nonnull BigInteger theInt) {
        Preconditions.checkNotNull((Object)theInt);
        return new BigIntegerLiteral(theInt);
    }

    @Nonnull
    public static Statement statement(@Nonnull Resource theSubject, @Nonnull IRI thePredicate, @Nonnull Value theObject) {
        Preconditions.checkNotNull((Object)theSubject);
        Preconditions.checkNotNull((Object)thePredicate);
        Preconditions.checkNotNull((Object)theObject);
        return new StatementImpl(theSubject, thePredicate, theObject, DEFAULT_GRAPH);
    }

    public static boolean isValid(Literal theLiteral) {
        Optional<String> aLang = theLiteral.lang();
        if (aLang.isPresent()) {
            return RFC3066.matcher(aLang.get()).matches();
        }
        if (theLiteral.datatype() != Datatype.UDF && theLiteral.datatypeIRI().namespace().equals("http://www.w3.org/2001/XMLSchema#")) {
            try {
                return XMLDatatypes.isValidValue(theLiteral.label(), theLiteral.datatype());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValid(IRI theIRI) {
        String iri = theIRI.toString();
        return !Values.containsInvalidIRICharacters(iri) && !Values.containsLeadingOrTrailingWhitespace(iri) && !iri.startsWith(":");
    }

    public static boolean containsInvalidIRICharacters(String theIRI) {
        return IRI_SYNTAX_REGEX.matchesAnyOf((CharSequence)theIRI);
    }

    public static boolean containsLeadingOrTrailingWhitespace(String theIRI) {
        return Character.isWhitespace(theIRI.codePointAt(0)) || Character.isWhitespace(theIRI.codePointAt(theIRI.length() - 1));
    }

    public static boolean isValid(Value theValue) {
        return theValue instanceof Literal ? Values.isValid((Literal)theValue) : (theValue instanceof IRI ? Values.isValid((IRI)theValue) : theValue != null);
    }

    @Nonnull
    public static Statement statement(@Nonnull Resource theSubject, @Nonnull IRI thePredicate, @Nonnull Value theObject, Resource theContext) {
        Preconditions.checkNotNull((Object)theSubject);
        Preconditions.checkNotNull((Object)thePredicate);
        Preconditions.checkNotNull((Object)theObject);
        Resource context = theContext == null ? DEFAULT_GRAPH : theContext;
        Resource subject = theSubject;
        if (subject instanceof Statement) {
            subject = Values.statement(((Statement)subject).subject(), ((Statement)subject).predicate(), ((Statement)subject).object(), theContext);
        }
        return new StatementImpl(subject, thePredicate, theObject, context);
    }

    public static boolean isDefaultGraph(Resource theContext) {
        return theContext == null || theContext == DEFAULT_GRAPH || DEFAULT_GRAPH.equals(theContext);
    }

    public static boolean isVirtual(Resource theContext) {
        return theContext.toString().startsWith(VIRTUAL_NAMESPACE);
    }

    public static boolean isInDefaultGraph(@Nonnull Statement theStmt) {
        return Values.isDefaultGraph(theStmt.context());
    }

    public static boolean isAll(@Nonnull Resource theContext) {
        return theContext == ALL_GRAPHS || ALL_GRAPHS.equals(theContext);
    }

    public static boolean isLocal(@Nonnull Resource theContext) {
        return theContext == LOCAL_GRAPHS || LOCAL_GRAPHS.equals(theContext);
    }

    public static boolean isNamed(@Nonnull Resource theContext) {
        return theContext == NAMED_GRAPHS || NAMED_GRAPHS.equals(theContext);
    }

    public static Resource resource(String id) {
        if (id.charAt(0) == '_' && id.charAt(1) == ':') {
            return Values.bnode(id.substring(2));
        }
        return Values.iri(id);
    }

    static {
        DatatypeFactory aDatatypeFactory = null;
        try {
            aDatatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("Cannot create javax.xml.datatype.DatatypeFactory instance", (Throwable)e);
        }
        DATATYPE_FACTORY = aDatatypeFactory;
    }
}

