/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.base.MoreObjects;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StatementPattern
implements Statement,
Predicate<Statement> {
    public static final IRI WILDCARD = Values.iri("tag:stark:statement_pattern:wildcard");
    private final Resource mSubject;
    private final IRI mPredicate;
    private final Value mObject;
    private final Resource mContext;

    private StatementPattern(Resource theSubject, IRI thePredicate, Value theObject, Resource theContext) {
        this.mSubject = theSubject;
        this.mPredicate = thePredicate;
        this.mObject = theObject;
        this.mContext = theContext;
    }

    @Override
    public boolean test(@Nonnull Statement theStatement) {
        return !(this.mSubject != WILDCARD && !this.mSubject.equals(theStatement.subject()) || this.mPredicate != WILDCARD && !this.mPredicate.equals(theStatement.predicate()) || this.mObject != WILDCARD && !this.mObject.equals(theStatement.object()) || this.mContext != WILDCARD && !this.mContext.equals(theStatement.context()));
    }

    @Override
    @Nonnull
    public Resource subject() {
        return this.mSubject;
    }

    @Override
    @Nonnull
    public IRI predicate() {
        return this.mPredicate;
    }

    @Override
    @Nonnull
    public Value object() {
        return this.mObject;
    }

    @Override
    @Nonnull
    public Resource context() {
        return this.mContext;
    }

    public boolean equals(Object theObj) {
        if (this == theObj) {
            return true;
        }
        if (theObj == null || this.getClass() != theObj.getClass()) {
            return false;
        }
        StatementPattern aStmt = (StatementPattern)theObj;
        return Objects.equals(this.mSubject, aStmt.mSubject) && Objects.equals(this.mPredicate, aStmt.mPredicate) && Objects.equals(this.mObject, aStmt.mObject) && Objects.equals(this.mContext, aStmt.mContext);
    }

    public int hashCode() {
        return Objects.hash(this.mSubject, this.mPredicate, this.mObject, this.mContext);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static StatementPattern o(@Nonnull Value theObject) {
        return new StatementPattern(WILDCARD, WILDCARD, theObject, WILDCARD);
    }

    @Nonnull
    public static StatementPattern p(@Nonnull IRI thePredicate) {
        return new StatementPattern(WILDCARD, thePredicate, WILDCARD, WILDCARD);
    }

    @Nonnull
    public static StatementPattern s(@Nonnull Resource theSubj) {
        return new StatementPattern(theSubj, WILDCARD, WILDCARD, WILDCARD);
    }

    @Nonnull
    public static StatementPattern sp(@Nonnull Resource theSubj, @Nonnull IRI thePred) {
        return new StatementPattern(theSubj, thePred, WILDCARD, WILDCARD);
    }

    @Nonnull
    public static StatementPattern spo(@Nonnull Resource theSubj, @Nonnull IRI thePred, @Nonnull Value theObj) {
        return new StatementPattern(theSubj, thePred, theObj, WILDCARD);
    }

    @Nonnull
    public static StatementPattern po(@Nonnull IRI thePred, @Nonnull Value theObject) {
        return new StatementPattern(WILDCARD, thePred, theObject, WILDCARD);
    }

    public static class Builder {
        private Resource mS = WILDCARD;
        private IRI mP = WILDCARD;
        private Value mO = WILDCARD;
        private Resource mC = WILDCARD;

        public StatementPattern build() {
            return new StatementPattern(this.mS, this.mP, this.mO, this.mC);
        }

        @Nonnull
        public Builder subject(@Nullable Resource theS) {
            this.mS = (Resource)MoreObjects.firstNonNull((Object)theS, (Object)WILDCARD);
            return this;
        }

        @Nonnull
        public Builder predicate(@Nullable IRI theP) {
            this.mP = (IRI)MoreObjects.firstNonNull((Object)theP, (Object)WILDCARD);
            return this;
        }

        @Nonnull
        public Builder object(@Nullable Value theO) {
            this.mO = (Value)MoreObjects.firstNonNull((Object)theO, (Object)WILDCARD);
            return this;
        }

        @Nonnull
        public Builder context(@Nullable Resource theC) {
            this.mC = (Resource)MoreObjects.firstNonNull((Object)theC, (Object)WILDCARD);
            return this;
        }
    }
}

