/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.collect.Lists;
import com.stardog.stark.BNode;
import com.stardog.stark.Graphs;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class RDFLists {
    @Nonnull
    public static Resource create(@Nonnull List<? extends Value> theList, @Nonnull Collection<Statement> theGraph) {
        return RDFLists.create(theList, theGraph::add);
    }

    @Nonnull
    public static Resource create(@Nonnull List<? extends Value> theList, @Nonnull Consumer<Statement> theGraph) {
        BNode aListHead;
        if (theList.isEmpty()) {
            return RDF.NIL;
        }
        BNode aListRes = aListHead = Values.bnode();
        Iterator<? extends Value> aResIter = theList.iterator();
        while (aResIter.hasNext()) {
            theGraph.accept(Values.statement(aListRes, RDF.FIRST, aResIter.next()));
            if (aResIter.hasNext()) {
                BNode aNextListElem = Values.bnode();
                theGraph.accept(Values.statement(aListRes, RDF.REST, aNextListElem));
                aListRes = aNextListElem;
                continue;
            }
            theGraph.accept(Values.statement(aListRes, RDF.REST, RDF.NIL));
        }
        return aListHead;
    }

    @Nonnull
    public static List<Value> fromStatements(@Nonnull Resource theResource, @Nonnull Iterable<Statement> theGraph) {
        return RDFLists.fromStatements(theResource, Lists.newArrayList(), theGraph, new HashSet<Resource>());
    }

    private static List<Value> fromStatements(@Nonnull Resource theResource, @Nonnull List<Value> theList, @Nonnull Iterable<Statement> theGraph, @Nonnull Set<Resource> theSeen) {
        if (!theResource.equals(RDF.NIL)) {
            Value aFirst = Graphs.object(theGraph, theResource, RDF.FIRST).orElseThrow(IllegalArgumentException::new);
            Resource aRest = (Resource)Graphs.object(theGraph, theResource, RDF.REST).orElseThrow(IllegalArgumentException::new);
            if (theSeen.add(aRest)) {
                theList.add(aFirst);
                RDFLists.fromStatements(aRest, theList, theGraph, theSeen);
            } else {
                throw new IllegalStateException("Cyclic RDF list detected at " + String.valueOf(aRest));
            }
        }
        return theList;
    }

    public RDFLists() {
        throw new AssertionError();
    }
}

