/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.collect.ImmutableSet;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.StatementPattern;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class Graphs {
    @Nonnull
    public static Set<Resource> subjects(@Nonnull Collection<Statement> theStatements) {
        return theStatements.stream().map(Statement::subject).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<IRI> predicates(@Nonnull Collection<Statement> theStatements) {
        return theStatements.stream().map(Statement::predicate).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<Value> objects(@Nonnull Collection<Statement> theStatements) {
        return theStatements.stream().map(Statement::object).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<Resource> contexts(@Nonnull Collection<Statement> theStatements) {
        return theStatements.stream().map(Statement::context).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<Statement> applyContext(@Nonnull Collection<Statement> theStatements, @Nonnull Resource theContext) {
        return theStatements.stream().map(Statements.applyContext(theContext)).collect(Collectors.toSet());
    }

    @Nonnull
    public static Stream<Statement> matching(@Nonnull Iterable<Statement> theStmts, @Nonnull StatementPattern thePattern) {
        return (theStmts instanceof Collection ? ((Collection)theStmts).stream() : StreamSupport.stream(theStmts.spliterator(), false)).filter(thePattern);
    }

    @Nonnull
    public static Optional<Value> object(@Nonnull Iterable<Statement> theStatements, @Nonnull Resource theSubj, @Nonnull IRI thePred) {
        return Graphs.matching(theStatements, StatementPattern.sp(theSubj, thePred)).map(Statement::object).findFirst();
    }

    @Nonnull
    public static Set<Statement> named(@Nonnull Iterable<Statement> theStatements, @Nonnull Resource theContext) {
        return StreamSupport.stream(theStatements.spliterator(), false).map(stmt -> {
            Resource subj = stmt.subject();
            if (subj instanceof Statement) {
                subj = Values.statement(((Statement)subj).subject(), ((Statement)subj).predicate(), ((Statement)subj).object(), theContext);
            }
            return Values.statement(subj, stmt.predicate(), stmt.object(), theContext);
        }).collect(Collectors.toSet());
    }

    public static boolean isList(@Nonnull Collection<Statement> theGraph, @Nonnull Resource theRes) {
        StatementPattern aPattern = StatementPattern.sp(theRes, RDF.FIRST);
        return Objects.equals(theRes, RDF.NIL) || theGraph.stream().anyMatch(aPattern);
    }

    @Nonnull
    public static List<Value> asList(@Nonnull Collection<Statement> theGraph, @Nonnull Resource theRes) {
        ArrayList<Value> aList = new ArrayList<Value>();
        Resource aListRes = theRes;
        while (aListRes != null) {
            Graphs.matching(theGraph, StatementPattern.sp(aListRes, RDF.FIRST)).map(Statement::object).filter(Resource.class::isInstance).map(Resource.class::cast).findFirst().ifPresent(aList::add);
            Optional<Resource> aRest = Graphs.matching(theGraph, StatementPattern.sp(aListRes, RDF.REST)).map(Statement::object).filter(Resource.class::isInstance).map(Resource.class::cast).findFirst();
            if (aRest.orElse(RDF.NIL).equals(RDF.NIL)) {
                aListRes = null;
                continue;
            }
            aListRes = aRest.get();
        }
        return aList;
    }

    @Nonnull
    public static Set<Statement> toList(@Nonnull List<Resource> theResources) {
        BNode aCurr = Values.bnode();
        int i = 0;
        HashSet<Statement> aGraph = new HashSet<Statement>();
        for (Resource aRes : theResources) {
            BNode aNext = Values.bnode();
            aGraph.add(Values.statement(aCurr, RDF.FIRST, aRes));
            aGraph.add(Values.statement(aCurr, RDF.REST, ++i < theResources.size() ? aNext : RDF.NIL));
            aCurr = aNext;
        }
        return aGraph;
    }

    public static boolean isomorphic(@Nonnull Iterable<? extends Statement> model1, @Nonnull Iterable<? extends Statement> model2) {
        Set<? extends Statement> set1 = Graphs.toSet(model1);
        Set<? extends Statement> set2 = Graphs.toSet(model2);
        return set1.size() == set2.size() && Graphs.matchModels(set1, set2);
    }

    private static boolean matchModels(@Nonnull Set<? extends Statement> theModel, @Nonnull Set<? extends Statement> theOtherModel) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(theModel.size());
        for (Statement statement : theModel) {
            Statement embeddedTriple;
            if (statement.subject() instanceof BNode || statement.object() instanceof BNode || statement.context() instanceof BNode) {
                model1BNodes.add(statement);
                continue;
            }
            if (statement.subject() instanceof Statement && ((embeddedTriple = (Statement)statement.subject()).subject() instanceof BNode || embeddedTriple.object() instanceof BNode || embeddedTriple.context() instanceof BNode)) {
                model1BNodes.add(embeddedTriple);
                continue;
            }
            if (theOtherModel.contains(statement)) continue;
            return false;
        }
        return Graphs.matchModels(model1BNodes, theOtherModel, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchModels(@Nonnull List<? extends Statement> model1, @Nonnull Iterable<? extends Statement> model2, @Nonnull Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = Graphs.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                if (st1.subject() instanceof BNode && st2.subject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.subject(), (BNode)st2.subject());
                }
                if (st1.object() instanceof BNode && st2.object() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.object(), (BNode)st2.object());
                }
                if (st1.context() instanceof BNode && st2.context() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.context(), (BNode)st2.context());
                }
                if (!(result = Graphs.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(@Nonnull Statement st, @Nonnull Iterable<? extends Statement> model, @Nonnull Map<BNode, BNode> bNodeMapping) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement statement : model) {
            if (Graphs.statementsMatch(st, statement, bNodeMapping)) {
                result.add(statement);
                continue;
            }
            if (!(statement.subject() instanceof Statement) || !Graphs.statementsMatch(st, (Statement)statement.subject(), bNodeMapping)) continue;
            result.add((Statement)statement.subject());
        }
        return result;
    }

    private static boolean statementsMatch(@Nonnull Statement st1, @Nonnull Statement st2, @Nonnull Map<BNode, BNode> bNodeMapping) {
        BNode mappedBNode;
        BNode mappedBNode2;
        BNode mappedBNode3;
        if (!st1.predicate().equals(st2.predicate())) {
            return false;
        }
        Resource subj1 = st1.subject();
        Resource subj2 = st2.subject();
        if (subj1 instanceof BNode && subj2 instanceof BNode ? ((mappedBNode3 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode3) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.object();
        Value obj2 = st2.object();
        if (obj1 instanceof BNode && obj2 instanceof BNode ? ((mappedBNode2 = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode2) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2)) {
            return false;
        }
        Resource context1 = st1.context();
        Resource context2 = st2.context();
        return !(context1 instanceof BNode && context2 instanceof BNode ? ((mappedBNode = bNodeMapping.get(context1)) != null ? !context2.equals(mappedBNode) : bNodeMapping.containsValue(context2)) : !context1.equals(context2));
    }

    private static <S extends Statement> Set<S> toSet(@Nonnull Iterable<S> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        return ImmutableSet.copyOf(iterable);
    }

    public static Stream<Resource> subjectsOfType(Iterable<Statement> theStatements, IRI theClass) {
        return Graphs.matching(theStatements, StatementPattern.po(RDF.TYPE, theClass)).map(Statement::subject);
    }
}

