/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.stardog.stark.IRI;
import com.stardog.stark.vocabs.RDF;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ExtractionQuery {
    public static String generate(Collection<IRI> types, Collection<IRI> properties) {
        return ExtractionQuery.generate(types, properties, Collections.emptyList());
    }

    public static String generate(Collection<IRI> types, Collection<IRI> properties, Collection<IRI> graphs) {
        String prefix = graphs.stream().map(g -> "FROM <" + String.valueOf(g) + ">").collect(Collectors.joining("\n", "CONSTRUCT { ?s ?p ?o }\n", "WHERE { #pragma reasoning off\n{"));
        String suffix = "}}";
        return Stream.concat(types.stream().map(ExtractionQuery::typePattern), properties.stream().map(ExtractionQuery::predicatePattern)).collect(Collectors.joining("\n} UNION {\n", prefix, suffix));
    }

    private static String predicatePattern(IRI p) {
        return ExtractionQuery.predicateObjectPattern(p, null);
    }

    private static String typePattern(IRI type) {
        return ExtractionQuery.predicateObjectPattern(RDF.TYPE, type);
    }

    private static String predicateObjectPattern(IRI p, IRI o) {
        String pattern = "?s ?p ?o FILTER(?p = <" + String.valueOf(p) + ">)";
        if (o != null) {
            pattern = pattern + " FILTER(?o = <" + String.valueOf(o) + ">)";
        }
        return pattern;
    }

    public ExtractionQuery() {
        throw new AssertionError();
    }
}

