/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.stardog.stark.Axiom;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.OWL;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.AxiomImpl;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import com.stardog.stark.vocabs.XSD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public final class Axioms {
    private Axioms() {
        throw new AssertionError();
    }

    public static Axiom rule(String theRuleBody) {
        return AxiomImpl.builder(Axioms.type((Resource)Values.bnode(), Values.iri("tag:stardog:api:rule:SPARQLRule"))).add(Values.iri("tag:stardog:api:rule:content"), Values.literal(theRuleBody)).build();
    }

    public static Axiom type(Resource theInd, IRI theClass) {
        return AxiomImpl.builder(theInd).add(RDF.TYPE, theClass).add(Axioms.namedClass(theClass)).build();
    }

    public static Axiom type(Resource theInd, Axiom.ClassExpression theClass) {
        return AxiomImpl.builder(theInd).add(RDF.TYPE, theClass).build();
    }

    public static Axiom fromStatements(Iterable<Statement> theStatements) {
        return AxiomImpl.builder().addAll(theStatements).build();
    }

    public static Axiom fromStatements(Statement ... theStatements) {
        return AxiomImpl.builder().addAll(Sets.newHashSet((Object[])theStatements)).build();
    }

    public static Axiom.ClassExpression namedClass(IRI theURI) {
        return ClassExpressionImpl.named(theURI);
    }

    public static Axiom.PropertyExpression transitiveProperty(IRI theURI) {
        return PropertyExpressionImpl.transitive(theURI);
    }

    public static Axiom.PropertyExpression reflexiveProperty(IRI theURI) {
        return PropertyExpressionImpl.reflexive(theURI);
    }

    public static Axiom.PropertyExpression irreflexiveProperty(IRI theURI) {
        return PropertyExpressionImpl.irreflexive(theURI);
    }

    public static Axiom.PropertyExpression symmetricProperty(IRI theURI) {
        return PropertyExpressionImpl.symmetric(theURI);
    }

    public static Axiom.PropertyExpression asymmetricProperty(IRI theURI) {
        return PropertyExpressionImpl.asymmetric(theURI);
    }

    public static Axiom.PropertyExpression functionalProperty(IRI theURI) {
        return PropertyExpressionImpl.functional(theURI);
    }

    public static Axiom.PropertyExpression inverseFunctionalProperty(IRI theURI) {
        return PropertyExpressionImpl.inverseFunctional(theURI);
    }

    public static Axiom.PropertyExpression inverse(IRI theProp) {
        return new PropertyExpressionImpl(AxiomImpl.builder(Values.bnode()).add(OWL.INVERSEOF, Axioms.objectProperty(theProp)).build());
    }

    public static Axiom.PropertyExpression inverse(Axiom.PropertyExpression theProp) {
        return new PropertyExpressionImpl(AxiomImpl.builder(Values.bnode()).add(OWL.INVERSEOF, Axioms.objectProperty((IRI)theProp.mainNode())).add(theProp).build());
    }

    public static Axiom subClassOf(Resource sub, Resource sup) {
        return AxiomImpl.builder(sub).add(RDFS.SUBCLASSOF, sup).build();
    }

    public static Axiom subClassOf(Axiom.ClassExpression sub, Axiom.ClassExpression sup) {
        return AxiomImpl.builder(sub).add(RDFS.SUBCLASSOF, sup).build();
    }

    public static Axiom subClassOf(Axiom.ClassExpression sub, Resource sup) {
        return AxiomImpl.builder(sub).add(RDFS.SUBCLASSOF, sup).build();
    }

    public static Axiom subClassOf(Resource sub, Axiom.ClassExpression sup) {
        return AxiomImpl.builder(sub).add(RDFS.SUBCLASSOF, sup).build();
    }

    public static Axiom range(IRI theProperty, Resource theClass) {
        return AxiomImpl.builder(theProperty).add(RDFS.RANGE, theClass).build();
    }

    public static Axiom range(Axiom.PropertyExpression theProperty, Resource theClass) {
        return AxiomImpl.builder(theProperty).add(RDFS.RANGE, theClass).build();
    }

    public static Axiom range(IRI theProperty, Axiom.ClassExpression theClass) {
        return Axioms.range(theProperty, theClass.mainNode());
    }

    public static Axiom range(IRI theProperty, Axiom.Datatype theRange) {
        return Axioms.range(theProperty, theRange.mainNode());
    }

    public static Axiom domain(IRI theProperty, Resource theClass) {
        return AxiomImpl.builder(theProperty).add(RDFS.DOMAIN, theClass).build();
    }

    public static Axiom domain(Axiom.PropertyExpression theProperty, Resource theClass) {
        return AxiomImpl.builder(theProperty).add(RDFS.DOMAIN, theClass).build();
    }

    public static Axiom domain(IRI theProperty, Axiom.ClassExpression theClass) {
        return Axioms.domain(theProperty, theClass.mainNode());
    }

    public static Axiom.ClassExpression some(IRI theProperty, Resource theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.SOMEVALUESFROM, theResource).build());
    }

    public static Axiom.ClassExpression some(IRI theProperty, Axiom theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.SOMEVALUESFROM, theResource.mainNode()).add(theResource).build());
    }

    public static Axiom.ClassExpression some(Axiom.PropertyExpression theProperty, Axiom theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.SOMEVALUESFROM, theResource.mainNode()).add(theResource).build());
    }

    public static Axiom.ClassExpression all(IRI theProperty, Resource theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.ALLVALUESFROM, theResource).build());
    }

    public static Axiom.ClassExpression all(Axiom.PropertyExpression theProperty, Resource theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.ALLVALUESFROM, theResource).build());
    }

    public static Axiom.ClassExpression all(IRI theProperty, Axiom theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.ALLVALUESFROM, theResource.mainNode()).add(theResource).build());
    }

    public static Axiom.ClassExpression all(Axiom.PropertyExpression theProperty, Axiom theResource) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.ALLVALUESFROM, theResource.mainNode()).add(theResource).add(theProperty).build());
    }

    public static Axiom.ClassExpression hasValue(IRI theProperty, Value theValue) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theProperty).add(OWL.HASVALUE, theValue).build());
    }

    public static Axiom.ClassExpression min(IRI theURI, int theCard) {
        return Axioms.min(theURI, theCard, OWL.THING);
    }

    public static Axiom.ClassExpression min(IRI theURI, int theCard, Resource theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theURI).add(OWL.MIN_QUALIFIED_CARDINALITY, Values.literal(String.valueOf(theCard), XSD.NON_NEGATIVE_INTEGER)).add(OWL.ON_CLASS, theClass).build());
    }

    public static Axiom.ClassExpression min(IRI theURI, int theCard, Axiom.ClassExpression theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Axioms.min(theURI, theCard, theClass.mainNode())).add(theClass).build());
    }

    public static Axiom.ClassExpression min(Axiom.PropertyExpression theURI, int theCard) {
        return Axioms.min(theURI, theCard, (Axiom.ClassExpression)new ClassExpressionImpl(OWL.THING));
    }

    public static Axiom.ClassExpression min(Axiom.PropertyExpression theURI, int theCard, Axiom.ClassExpression theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theURI).add(OWL.MIN_QUALIFIED_CARDINALITY, Values.literal(String.valueOf(theCard), XSD.NON_NEGATIVE_INTEGER)).add(OWL.ON_CLASS, theClass).build());
    }

    public static Axiom.ClassExpression max(Axiom.PropertyExpression theURI, int theCard) {
        return Axioms.max(theURI, theCard, (Axiom.ClassExpression)new ClassExpressionImpl(OWL.THING));
    }

    public static Axiom.ClassExpression max(Axiom.PropertyExpression theURI, int theCard, Axiom.ClassExpression theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theURI).add(OWL.MAX_QUALIFIED_CARDINALITY, Values.literal(String.valueOf(theCard), XSD.NON_NEGATIVE_INTEGER)).add(OWL.ON_CLASS, theClass).build());
    }

    public static Axiom.ClassExpression max(IRI theURI, int theCard) {
        return Axioms.max(theURI, theCard, OWL.THING);
    }

    public static Axiom.ClassExpression max(IRI theURI, int theCard, Resource theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theURI).add(OWL.MAX_QUALIFIED_CARDINALITY, Values.literal(String.valueOf(theCard), XSD.NON_NEGATIVE_INTEGER)).add(OWL.ON_CLASS, theClass).build());
    }

    public static Axiom.ClassExpression max(IRI theURI, int theCard, Axiom.ClassExpression theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Axioms.max(theURI, theCard, theClass.mainNode())).add(theClass).build());
    }

    public static Axiom.ClassExpression cardinality(IRI theURI, int theCard) {
        return Axioms.cardinality(theURI, theCard, OWL.THING);
    }

    public static Axiom.ClassExpression cardinality(IRI theURI, int theCard, Resource theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.RESTRICTION).add(OWL.ONPROPERTY, theURI).add(OWL.QUALIFIED_CARDINALITY, Values.literal(String.valueOf(theCard), XSD.NON_NEGATIVE_INTEGER)).add(OWL.ON_CLASS, theClass).build());
    }

    public static Axiom.ClassExpression cardinality(IRI theURI, int theCard, Axiom.ClassExpression theClass) {
        return new ClassExpressionImpl(AxiomImpl.builder(Axioms.cardinality(theURI, theCard, theClass.mainNode())).add(theClass).build());
    }

    public static Axiom.ClassExpression or(Axiom.ClassExpression ... theExpr) {
        Preconditions.checkArgument((theExpr != null && theExpr.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return new ClassExpressionImpl(AxiomImpl.of((Resource)Values.bnode(), OWL.UNIONOF, new ExpressionList(Lists.newArrayList((Object[])theExpr))));
    }

    public static Axiom.ClassExpression or(Resource ... ex) {
        Preconditions.checkArgument((ex != null && ex.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return new ClassExpressionImpl(AxiomImpl.of((Resource)Values.bnode(), OWL.UNIONOF, new ExpressionList<Axiom.ClassExpression>(Axioms.toClassExpressions(ex))));
    }

    public static Axiom.ClassExpression and(Axiom.ClassExpression ... theExpr) {
        Preconditions.checkArgument((theExpr != null && theExpr.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return new ClassExpressionImpl(AxiomImpl.of((Resource)Values.bnode(), OWL.INTERSECTIONOF, new ExpressionList(Lists.newArrayList((Object[])theExpr))));
    }

    public static Axiom.ClassExpression and(Resource ... ex) {
        Preconditions.checkArgument((ex != null && ex.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return new ClassExpressionImpl(AxiomImpl.of((Resource)Values.bnode(), OWL.INTERSECTIONOF, new ExpressionList<Axiom.ClassExpression>(Axioms.toClassExpressions(ex))));
    }

    private static List<Axiom> toExpressions(Resource ... theResources) {
        ArrayList aList = Lists.newArrayList();
        for (Resource aRes : theResources) {
            aList.add(AxiomImpl.builder(aRes).build());
        }
        return aList;
    }

    private static List<Axiom.ClassExpression> toClassExpressions(Resource ... theResources) {
        ArrayList aList = Lists.newArrayList();
        for (Resource aRes : theResources) {
            aList.add(new ClassExpressionImpl(aRes));
        }
        return aList;
    }

    private static List<Axiom.PropertyExpression> toPropertyExpressions(IRI ... theURIs) {
        ArrayList aList = Lists.newArrayList();
        for (IRI aURI : theURIs) {
            aList.add(new PropertyExpressionImpl(aURI));
        }
        return aList;
    }

    public static Axiom.ClassExpression complementOf(Resource theRes) {
        return new ClassExpressionImpl(AxiomImpl.of((Resource)Values.bnode(), OWL.COMPLEMENTOF, theRes));
    }

    public static Axiom disjointClasses(Axiom.ClassExpression ... theClasses) {
        Preconditions.checkArgument((theClasses != null && theClasses.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        AxiomImpl.AxiomBuilder aExpr = AxiomImpl.builder().addAll(Axioms.assertCrossProduct(Arrays.asList(theClasses).stream().map(Axiom::mainNode).collect(Collectors.toList()), OWL.DISJOINTWITH));
        for (Axiom.ClassExpression aInd : theClasses) {
            aExpr.add(aInd);
        }
        return aExpr.build();
    }

    public static Axiom disjointClasses(Resource ... theClasses) {
        Preconditions.checkArgument((theClasses != null && theClasses.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertCrossProduct(Arrays.asList(theClasses), OWL.DISJOINTWITH)).build();
    }

    public static Axiom equivalentClasses(Axiom.ClassExpression ... theClasses) {
        Preconditions.checkArgument((theClasses != null && theClasses.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        AxiomImpl.AxiomBuilder aExpr = AxiomImpl.builder().addAll(Axioms.assertLinear(Arrays.asList(theClasses).stream().map(Axiom::mainNode).collect(Collectors.toList()), OWL.EQUIVALENTCLASS));
        for (Axiom.ClassExpression aInd : theClasses) {
            aExpr.add(aInd);
        }
        return aExpr.build();
    }

    public static Axiom equivalentClasses(Resource ... theClasses) {
        Preconditions.checkArgument((theClasses != null && theClasses.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertLinear(Arrays.asList(theClasses), OWL.EQUIVALENTCLASS)).build();
    }

    public static Axiom equivalentProperties(Resource ... theProperties) {
        Preconditions.checkArgument((theProperties != null && theProperties.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertLinear(Arrays.asList(theProperties), OWL.EQUIVALENTPROPERTY)).build();
    }

    public static Axiom classAssertion(Resource theIndividual, Resource theClass) {
        return AxiomImpl.of(theIndividual, RDF.TYPE, theClass);
    }

    public static Axiom differentIndividuals(Resource ... theIndividuals) {
        Preconditions.checkArgument((theIndividuals != null && theIndividuals.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertCrossProduct(Arrays.asList(theIndividuals), OWL.DIFFERENTFROM)).build();
    }

    public static Axiom differentIndividuals(Axiom ... theIndividuals) {
        Preconditions.checkArgument((theIndividuals != null && theIndividuals.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        AxiomImpl.AxiomBuilder aExpr = AxiomImpl.builder().addAll(Axioms.assertCrossProduct(Arrays.asList(theIndividuals).stream().map(Axiom::mainNode).collect(Collectors.toList()), OWL.DIFFERENTFROM));
        for (Axiom aInd : theIndividuals) {
            aExpr.add(aInd);
        }
        return aExpr.build();
    }

    public static Axiom disjointDataProperties(IRI ... theProperties) {
        Preconditions.checkArgument((theProperties != null && theProperties.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertCrossProduct(Arrays.asList(theProperties), OWL.DISJOINT_DATA_PROPERTIES)).build();
    }

    public static Axiom disjointObjectProperties(IRI ... theProperties) {
        Preconditions.checkArgument((theProperties != null && theProperties.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertCrossProduct(Arrays.asList(theProperties), OWL.DISJOINT_OBJECT_PROPERTIES)).build();
    }

    public static Axiom sameIndividuals(Resource ... theIndividuals) {
        Preconditions.checkArgument((theIndividuals != null && theIndividuals.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        return AxiomImpl.builder().addAll(Axioms.assertLinear(Arrays.asList(theIndividuals), OWL.SAMEAS)).build();
    }

    private static Set<Statement> assertCrossProduct(List<Resource> theResource, IRI thePredicate) {
        HashSet<Statement> aGraph = new HashSet<Statement>();
        for (int i = 0; i < theResource.size(); ++i) {
            for (int j = 0; j < theResource.size(); ++j) {
                if (i == j) continue;
                aGraph.add(Values.statement(theResource.get(i), thePredicate, theResource.get(j)));
            }
        }
        return aGraph;
    }

    private static Set<Statement> assertLinear(List<Resource> theResources, IRI thePredicate) {
        HashSet<Statement> aGraph = new HashSet<Statement>();
        if (!theResources.isEmpty()) {
            Resource aResource = theResources.get(0);
            for (int i = 1; i < theResources.size(); ++i) {
                aGraph.add(Values.statement(aResource, thePredicate, theResources.get(i)));
            }
        }
        return aGraph;
    }

    public static Axiom negativeObjectPropertyAssertion(Resource theSubject, IRI thePredicate, Value theObject) {
        return AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.NEGATIVE_OP_ASSERTION).add(OWL.SOURCE_INDIVIDUAL, theSubject).add(OWL.ASSERTION_PROPERTY, thePredicate).add(OWL.TARGET_INDIVIDUAL, theObject).build();
    }

    public static Axiom negativeDataPropertyAssertion(Resource theSubject, IRI thePredicate, Value theObject) {
        return AxiomImpl.builder(Values.bnode()).add(RDF.TYPE, OWL.NEGATIVE_DP_ASSERTION).add(OWL.SOURCE_INDIVIDUAL, theSubject).add(OWL.ASSERTION_PROPERTY, thePredicate).add(OWL.TARGET_VALUE, theObject).build();
    }

    public static Axiom.PropertyExpression dataProperty(IRI theURI) {
        return PropertyExpressionImpl.dataProperty(theURI);
    }

    public static Axiom.PropertyExpression objectProperty(IRI theURI) {
        return PropertyExpressionImpl.objectProperty(theURI);
    }

    public static Axiom declareClass(IRI theURI) {
        return AxiomImpl.of((Resource)theURI, OWL.DECLARATION, OWL.CLASS);
    }

    public static Axiom declareObjectProperty(IRI theURI) {
        return AxiomImpl.of((Resource)theURI, OWL.DECLARATION, OWL.OBJECTPROPERTY);
    }

    public static Axiom declareDataProperty(IRI theURI) {
        return AxiomImpl.of((Resource)theURI, OWL.DECLARATION, OWL.DATATYPEPROPERTY);
    }

    public static Axiom declareIndividual(Resource theResource) {
        return AxiomImpl.of(theResource, OWL.DECLARATION, OWL.NAMED_INDIVIDUAL);
    }

    public static Axiom subPropertyOf(ExpressionList<Axiom.PropertyExpression> theList, Axiom.PropertyExpression theProperty) {
        return AxiomImpl.builder(theProperty).add(OWL.PROPERTY_CHAIN_AXIOM, theList).build();
    }

    public static Axiom subPropertyOf(IRI theSub, IRI theSuper) {
        return AxiomImpl.builder(theSub).add(RDFS.SUBPROPERTYOF, theSuper).build();
    }

    public static Axiom subPropertyOf(Axiom.PropertyExpression theSub, Axiom.PropertyExpression theSuper) {
        return AxiomImpl.builder(theSub).add(RDFS.SUBPROPERTYOF, theSuper).build();
    }

    public static ExpressionList<Axiom.PropertyExpression> propertyList(IRI ... theProps) {
        return new ExpressionList<Axiom.PropertyExpression>(Axioms.toPropertyExpressions(theProps));
    }

    public static ExpressionList<Axiom.PropertyExpression> propertyList(Axiom.PropertyExpression ... theExpr) {
        return new ExpressionList<Axiom.PropertyExpression>(Lists.newArrayList((Object[])theExpr));
    }

    public static Axiom subPropertyOf(Axiom.PropertyExpression theSub, IRI theSuper) {
        return AxiomImpl.builder(theSub).add(RDFS.SUBPROPERTYOF, theSuper).build();
    }

    public static Axiom subPropertyOf(IRI theSub, Axiom.PropertyExpression theSuper) {
        return AxiomImpl.builder(theSub).add(RDFS.SUBPROPERTYOF, theSuper).build();
    }

    public static Axiom inverseOf(IRI theProperty, IRI theInverse) {
        return AxiomImpl.builder(theProperty).add(OWL.INVERSEOF, theInverse).build();
    }

    public static Axiom inverseOf(Axiom.PropertyExpression theProperty, Axiom.PropertyExpression theInverse) {
        return AxiomImpl.builder(theProperty).add(OWL.INVERSEOF, theInverse).build();
    }

    public static Axiom inverseOf(Axiom.PropertyExpression theProperty, IRI theInverse) {
        return AxiomImpl.builder(theProperty).add(OWL.INVERSEOF, theInverse).build();
    }

    public static Axiom inverseOf(IRI theProperty, Axiom.PropertyExpression theInverse) {
        return AxiomImpl.builder(theProperty).add(OWL.INVERSEOF, theInverse).build();
    }

    public static RestrictedDatatype restrict(Axiom.NamedDatatype theDatatype, FacetRestriction ... theRestrictions) {
        return new RestrictedDatatype(theDatatype.datatype(), Sets.newHashSet((Object[])theRestrictions));
    }

    public static Axiom.ClassExpression oneOf(Resource ... ex) {
        Preconditions.checkArgument((ex != null && ex.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        AxiomImpl.AxiomBuilder theExpression = ClassExpressionImpl.cls(Values.bnode());
        theExpression.add(OWL.ONEOF, Axioms.createList(theExpression, Arrays.asList(ex)));
        return new ClassExpressionImpl(theExpression.build());
    }

    public static Axiom.Datatype oneOf(Literal ... ex) {
        Preconditions.checkArgument((ex != null && ex.length > 0 ? 1 : 0) != 0, (Object)"Cannot create expression from an empty list");
        AxiomImpl.AxiomBuilder theExpression = DatatypeImpl.datatypeBuilder(Values.bnode());
        theExpression.add(OWL.ONEOF, Axioms.createList(theExpression, Arrays.asList(ex)));
        return new DatatypeImpl(theExpression.build());
    }

    private static Resource createList(AxiomImpl.AxiomBuilder theExpr, List<? extends Value> theValues) {
        BNode aHead;
        BNode aCurr = aHead = Values.bnode();
        int i = 0;
        for (Value value : theValues) {
            BNode aNext = Values.bnode();
            theExpr.add(aCurr, RDF.FIRST, value);
            theExpr.add(aCurr, RDF.REST, ++i < theValues.size() ? aNext : RDF.NIL);
            aCurr = aNext;
        }
        return aHead;
    }

    private static class ClassExpressionImpl
    extends AxiomImpl
    implements Axiom.ClassExpression {
        ClassExpressionImpl(Resource theAxiom) {
            super(theAxiom, new HashSet<Statement>());
        }

        ClassExpressionImpl(Axiom theAxiom) {
            super(theAxiom);
        }

        static AxiomImpl.AxiomBuilder cls(Resource theRoot) {
            return ClassExpressionImpl.builder(theRoot).add(RDF.TYPE, OWL.CLASS);
        }

        static Axiom.ClassExpression named(Resource theRoot) {
            return new ClassExpressionImpl(ClassExpressionImpl.cls(theRoot).build());
        }
    }

    private static class PropertyExpressionImpl
    extends AxiomImpl
    implements Axiom.PropertyExpression {
        PropertyExpressionImpl(Resource theAxiom) {
            super(theAxiom, new HashSet<Statement>());
        }

        PropertyExpressionImpl(Axiom theAxiom) {
            super(theAxiom);
        }

        static AxiomImpl.AxiomBuilder prop(Resource theRoot, IRI theType) {
            return PropertyExpressionImpl.builder(theRoot).add(RDF.TYPE, theType);
        }

        static AxiomImpl.AxiomBuilder prop(Axiom theRoot, IRI theType) {
            return PropertyExpressionImpl.builder(theRoot).add(RDF.TYPE, theType);
        }

        static Axiom.PropertyExpression inverseFunctional(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.INVERSEFUNCTIONALPROPERTY).build());
        }

        static Axiom.PropertyExpression functional(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.FUNCTIONALPROPERTY).build());
        }

        static Axiom.PropertyExpression dataProperty(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.DATATYPEPROPERTY).build());
        }

        static Axiom.PropertyExpression objectProperty(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.OBJECTPROPERTY).build());
        }

        static Axiom.PropertyExpression transitive(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.TRANSITIVEPROPERTY).build());
        }

        static Axiom.PropertyExpression reflexive(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.REFLEXIVE).build());
        }

        static Axiom.PropertyExpression irreflexive(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.IRREFLEXIVE).build());
        }

        static Axiom.PropertyExpression asymmetric(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.ASYMMETRIC).build());
        }

        static Axiom.PropertyExpression symmetric(Resource theRoot) {
            return new PropertyExpressionImpl(PropertyExpressionImpl.prop(theRoot, OWL.SYMMETRICPROPERTY).build());
        }
    }

    public static class ExpressionList<T extends Axiom>
    implements Axiom {
        private final Axiom mAxiom;

        public ExpressionList(List<T> theElements) {
            Resource aHead;
            AxiomImpl.AxiomBuilder aBuilder = AxiomImpl.builder(Values.bnode());
            Resource aCurr = aHead = aBuilder.mainNode();
            int i = 0;
            for (Axiom r : theElements) {
                BNode aNext = Values.bnode();
                aBuilder.add(aCurr, RDF.FIRST, r.mainNode());
                aBuilder.add(aCurr, RDF.REST, ++i < theElements.size() ? aNext : RDF.NIL);
                aBuilder.add(r);
                aCurr = aNext;
            }
            this.mAxiom = aBuilder.build();
        }

        @Override
        @Nullable
        public Resource mainNode() {
            return this.mAxiom.mainNode();
        }

        @Override
        public Iterator<Statement> iterator() {
            return this.mAxiom.iterator();
        }
    }

    public static class RestrictedDatatype
    extends NamedDatatypeImpl {
        private final Set<FacetRestriction> mRestrictions;
        private final Axiom mAxiom;

        RestrictedDatatype(IRI theResource, Set<FacetRestriction> theRestrictions) {
            super(theResource);
            this.mRestrictions = theRestrictions;
            BNode aHead = Values.bnode();
            AxiomImpl.AxiomBuilder aBuilder = AxiomImpl.builder(theResource);
            Resource aRes = aBuilder.mainNode();
            aBuilder.add(aRes, RDF.TYPE, RDFS.DATATYPE);
            aBuilder.add(aRes, OWL.ON_DATATYPE, this.mDatatype);
            aBuilder.add(aRes, OWL.WITH_RESTRICTIONS, aHead);
            Iterator<FacetRestriction> aIter = this.mRestrictions.iterator();
            BNode aCurr = aHead;
            while (aIter.hasNext()) {
                FacetRestriction aRestriction = aIter.next();
                BNode aElem = Values.bnode();
                aBuilder.add(aElem, aRestriction.mFacet.getURI(), aRestriction.mValue);
                aBuilder.add(aCurr, RDF.FIRST, aElem);
                if (!aIter.hasNext()) {
                    aBuilder.add(aCurr, RDF.REST, RDF.NIL);
                    continue;
                }
                BNode aRest = Values.bnode();
                aBuilder.add(aCurr, RDF.REST, aRest);
                aCurr = aRest;
            }
            this.mAxiom = aBuilder.build();
        }

        @Override
        @Nonnull
        public Set<Statement> graph() {
            return ImmutableSet.copyOf((Iterable)this.mAxiom);
        }

        @Override
        public Iterator<Statement> iterator() {
            return this.mAxiom.iterator();
        }

        @Override
        public RestrictedDatatype minInclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.minInclusive, theValue)).build());
        }

        @Override
        public RestrictedDatatype maxInclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.maxInclusive, theValue)).build());
        }

        @Override
        public RestrictedDatatype minExclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.minExclusive, theValue)).build());
        }

        @Override
        public RestrictedDatatype maxExclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.maxExclusive, theValue)).build());
        }

        @Override
        public RestrictedDatatype length(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.length, theValue)).build());
        }

        @Override
        public RestrictedDatatype maxLength(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.maxLength, theValue)).build());
        }

        @Override
        public RestrictedDatatype pattern(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.pattern, theValue)).build());
        }

        @Override
        public RestrictedDatatype langRange(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.builder().addAll(this.mRestrictions).add((Object)new FacetRestriction(Facet.langRange, theValue)).build());
        }
    }

    private static class DatatypeImpl
    extends AxiomImpl
    implements Axiom.Datatype {
        DatatypeImpl(IRI theIRI) {
            super(theIRI, (Set<Statement>)ImmutableSet.of());
        }

        DatatypeImpl(Axiom theAxiom) {
            super(theAxiom);
        }

        static AxiomImpl.AxiomBuilder datatypeBuilder(Resource theRoot) {
            return DatatypeImpl.builder(theRoot).add(RDF.TYPE, RDFS.DATATYPE);
        }
    }

    public static class FacetRestriction {
        public final Facet mFacet;
        public final Literal mValue;

        public FacetRestriction(Facet theFacet, Literal theValue) {
            this.mFacet = theFacet;
            this.mValue = theValue;
        }
    }

    private static class NamedDatatypeImpl
    extends DatatypeImpl
    implements Axiom.NamedDatatype {
        protected final IRI mDatatype;

        NamedDatatypeImpl(IRI theResource) {
            super(theResource);
            this.mDatatype = theResource;
        }

        @Override
        public IRI datatype() {
            return this.mDatatype;
        }

        public RestrictedDatatype minInclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.minInclusive, theValue)));
        }

        public RestrictedDatatype maxInclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.maxInclusive, theValue)));
        }

        public RestrictedDatatype minExclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.minExclusive, theValue)));
        }

        public RestrictedDatatype maxExclusive(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.maxExclusive, theValue)));
        }

        public RestrictedDatatype length(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.length, theValue)));
        }

        public RestrictedDatatype maxLength(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.maxLength, theValue)));
        }

        public RestrictedDatatype pattern(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.pattern, theValue)));
        }

        public RestrictedDatatype langRange(Literal theValue) {
            return new RestrictedDatatype(this.mDatatype, (Set<FacetRestriction>)ImmutableSet.of((Object)new FacetRestriction(Facet.langRange, theValue)));
        }
    }

    public static enum Facet {
        minInclusive(Values.iri("http://www.w3.org/2001/XMLSchema#minInclusive")),
        maxInclusive(Values.iri("http://www.w3.org/2001/XMLSchema#maxInclusive")),
        minExclusive(Values.iri("http://www.w3.org/2001/XMLSchema#minExclusive")),
        maxExclusive(Values.iri("http://www.w3.org/2001/XMLSchema#maxExclusive")),
        length(Values.iri("http://www.w3.org/2001/XMLSchema#length")),
        maxLength(Values.iri("http://www.w3.org/2001/XMLSchema#maxLength")),
        pattern(Values.iri("http://www.w3.org/2001/XMLSchema#pattern")),
        langRange(Values.iri("http://www.w3.org/1999/02/22-rdf-syntax-ns#langRange"));

        private final IRI mURI;

        private Facet(IRI theURI) {
            this.mURI = theURI;
        }

        public IRI getURI() {
            return this.mURI;
        }
    }

    public static final class Datatypes {
        public static final Axiom.NamedDatatype Integer = new NamedDatatypeImpl(XSD.INTEGER);
        public static final Axiom.NamedDatatype Int = new NamedDatatypeImpl(XSD.INT);
        public static final Axiom.NamedDatatype String = new NamedDatatypeImpl(XSD.STRING);
        public static final Axiom.NamedDatatype Float = new NamedDatatypeImpl(XSD.FLOAT);
        public static final Axiom.NamedDatatype Double = new NamedDatatypeImpl(XSD.DOUBLE);
        public static final Axiom.NamedDatatype Decimal = new NamedDatatypeImpl(XSD.DECIMAL);

        private Datatypes() {
            throw new AssertionError();
        }

        public static NamedDatatypeImpl create(IRI theURI) {
            return new NamedDatatypeImpl(theURI);
        }
    }
}

