/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.stardog.ContextSets;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.ValidationReporter;
import com.stardog.stark.IRI;
import com.stardog.stark.query.BindingSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public interface ICValidator
extends AutoCloseable {
    default public boolean isValid(Constraint ... theConstraints) throws StardogException {
        return this.isValid((Collection<IRI>)ContextSets.LOCAL, theConstraints);
    }

    default public boolean isValid(Collection<IRI> theActiveGraphs, Constraint ... theConstraints) throws StardogException {
        return CloseableIterator.isEmpty(this.reporter().constraints(Arrays.asList(theConstraints)).graphs(theActiveGraphs).countLimit(1).results());
    }

    default public CloseableIterator<BindingSet> getViolationBindings(Constraint ... theConstraints) throws StardogException {
        return this.getViolationBindings((Collection<IRI>)ContextSets.LOCAL, theConstraints);
    }

    public CloseableIterator<BindingSet> getViolationBindings(Collection<IRI> var1, Constraint ... var2) throws StardogException;

    default public StatementIterator getValidationReport(Constraint ... theConstraints) throws StardogException {
        return this.getValidationReport((Collection<IRI>)ContextSets.LOCAL, theConstraints);
    }

    default public StatementIterator getValidationReport(Collection<IRI> theActiveGraphs, Constraint ... theConstraints) throws StardogException {
        return this.getValidationReport(theActiveGraphs, Options.empty(), theConstraints);
    }

    default public StatementIterator getValidationReport(Collection<IRI> theActiveGraphs, Options theOptions, Constraint ... theConstraints) throws StardogException {
        return this.reporter().graphs(theActiveGraphs).options(theOptions).constraints(Arrays.asList(theConstraints)).report();
    }

    public ValidationReporter reporter();

    public Set<Constraint> getConstraints() throws StardogException;

    @Override
    public void close();
}

