/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.icv;

import com.complexible.stardog.icv.Constraint;
import com.complexible.stardog.icv.shacl.ShaclConstraint;
import com.complexible.stardog.icv.shacl.ShaclReader;
import com.complexible.stardog.icv.shacl.Shape;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstraintFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintFactory.class);

    private static boolean isShaclTerm(Value theValue) {
        return theValue instanceof IRI && ConstraintFactory.isShaclTerm((IRI)theValue);
    }

    private static boolean isShaclTerm(IRI theIRI) {
        return theIRI.namespace().equals("http://www.w3.org/ns/shacl#");
    }

    private ConstraintFactory() {
        throw new AssertionError();
    }

    public static Constraint constraint(Iterable<Statement> theStatements) {
        Set<Constraint> aConstraints = ConstraintFactory.constraints(theStatements);
        if (aConstraints.size() != 1) {
            throw new IllegalArgumentException("Cannot create Constraint Axiom from graph, multiple axioms are identified");
        }
        return aConstraints.iterator().next();
    }

    public static Set<Constraint> constraints(Iterable<Statement> theGraph) {
        return ConstraintFactory.constraints(theGraph.iterator());
    }

    public static Set<Constraint> constraints(Iterator<Statement> theGraph) {
        HashSet aConstraints = Sets.newHashSet();
        Collection aTriples = theGraph instanceof Collection ? (Collection)((Object)theGraph) : Lists.newArrayList(theGraph);
        Map aShapes = new ShaclReader().readShapes(aTriples);
        for (Shape aShape : aShapes.values()) {
            if (aShape.getTargets().isEmpty()) continue;
            aConstraints.add(new ShaclConstraint(aShape));
        }
        return aConstraints;
    }
}

