/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.text.tsv;

import com.complexible.common.base.Options;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class SPARQLTSVResultWriter
implements SelectQueryResultWriter {
    private final Writer mWriter;
    private final Options mOptions;
    private boolean mHeaderWritten = false;
    private List<String> mVars = ImmutableList.of();

    public SPARQLTSVResultWriter(OutputStream theStream, Options theOptions) {
        this.mWriter = new OutputStreamWriter(theStream, this.format().charset());
        this.mOptions = theOptions;
    }

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.TSV;
    }

    public void end() {
        try {
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void links(@Nonnull List<String> theLinks) {
    }

    public void start() {
    }

    public void handle(@Nonnull BindingSet theBindings) throws ResultWritingFailed {
        if (!this.mHeaderWritten) {
            throw new ResultWritingFailed("Header row is mandatory in SPARQL/TSV results");
        }
        try {
            this.mWriter.write(this.mVars.stream().map(v -> theBindings.value(v).map(this::writeValue).orElse("")).collect(Collectors.joining("\t")));
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    private String writeValue(@Nonnull Value theValue) {
        try {
            if (theValue instanceof Literal) {
                return this.writeLiteral((Literal)theValue);
            }
            if (theValue instanceof BNode) {
                return this.writeBNode((BNode)theValue);
            }
            if (theValue instanceof IRI) {
                return this.writeURI((IRI)theValue);
            }
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(theValue.getClass()));
    }

    private String writeURI(@Nonnull IRI uri) {
        return "<" + uri.toString() + ">";
    }

    private String writeBNode(@Nonnull BNode bNode) {
        return "_:" + bNode.id();
    }

    @Nonnull
    private String writeLiteral(@Nonnull Literal lit) throws IOException {
        String label = lit.label();
        if (Datatype.INTEGER.equals((Object)lit.datatype()) || Datatype.DECIMAL.equals((Object)lit.datatype()) || Datatype.DOUBLE.equals((Object)lit.datatype())) {
            try {
                return XMLDatatypes.normalize((String)label, (Datatype)lit.datatype());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        StringBuilder aBuilder = new StringBuilder();
        aBuilder.append("\"");
        aBuilder.append(SPARQLTSVResultWriter.encodeString(label));
        aBuilder.append("\"");
        if (Literal.isLanguageLiteral((Literal)lit)) {
            aBuilder.append("@");
            aBuilder.append((String)lit.lang().get());
        } else if (!Datatype.STRING.equals((Object)lit.datatype()) || !this.mOptions.is(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL)) {
            aBuilder.append("^^");
            aBuilder.append(this.writeURI(lit.datatypeIRI()));
        }
        return aBuilder.toString();
    }

    private static String encodeString(String theStr) {
        String s = theStr;
        s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
        s = StringUtils.replace((String)s, (String)"\t", (String)"\\t");
        s = StringUtils.replace((String)s, (String)"\n", (String)"\\n");
        s = StringUtils.replace((String)s, (String)"\r", (String)"\\r");
        s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
        return s;
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) throws ResultWritingFailed {
    }

    public void variables(@Nonnull List<String> theVars) {
        if (this.mHeaderWritten) {
            throw new ResultWritingFailed("Cannot write header to csv more than once");
        }
        this.mHeaderWritten = true;
        try {
            this.mWriter.write(theVars.stream().map(s -> "?" + s).collect(Collectors.joining("\t")));
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
        this.mVars = theVars;
    }

    public static final class SPARQLTSVResultWriterFactory
    implements QueryResultWriterFactory {
        @Nonnull
        public QueryResultFormat format() {
            return QueryResultFormats.TSV;
        }

        @Nonnull
        public QueryResultWriter create(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
            return new SPARQLTSVResultWriter(theOutputStream, theOptions);
        }
    }
}

