/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.text.csv;

import com.complexible.common.base.Options;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.Datatype;
import com.stardog.stark.Literal;
import com.stardog.stark.Value;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterFactory;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.SelectQueryResultWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class SPARQLCSVResultWriter
implements SelectQueryResultWriter {
    private final Writer mWriter;
    private boolean mHeaderWritten = false;
    private List<String> mVars = ImmutableList.of();

    public SPARQLCSVResultWriter(@Nonnull OutputStream theOutputStream) {
        this.mWriter = new OutputStreamWriter(theOutputStream, this.format().charset());
    }

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.CSV;
    }

    public void variables(@Nonnull List<String> theVars) {
        if (this.mHeaderWritten) {
            throw new ResultWritingFailed("Cannot write header to csv more than once");
        }
        this.mHeaderWritten = true;
        try {
            this.mWriter.write(theVars.stream().collect(Collectors.joining(",")));
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
        this.mVars = theVars;
    }

    public void start() {
    }

    public void links(@Nonnull List<String> theLinks) {
    }

    public void handle(@Nonnull BindingSet theBindings) throws ResultWritingFailed {
        if (!this.mHeaderWritten) {
            throw new ResultWritingFailed("Header row is mandatory in SPARQL/CSV results");
        }
        try {
            this.mWriter.write(this.mVars.stream().map(v -> theBindings.value(v).map(this::writeValue).orElse("")).collect(Collectors.joining(",")));
            this.mWriter.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    private String writeValue(@Nonnull Value theValue) {
        try {
            if (theValue instanceof Literal) {
                return this.writeLiteral((Literal)theValue);
            }
            return theValue.toString();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    @Nonnull
    private String writeLiteral(@Nonnull Literal literal) throws IOException {
        String aLabel = literal.label();
        boolean quoted = false;
        if (XMLDatatypes.isIntegerDatatype((Datatype)literal.datatype()) || XMLDatatypes.isDecimalDatatype((Datatype)literal.datatype()) || literal.datatype() == Datatype.DOUBLE) {
            try {
                return XMLDatatypes.normalize((String)aLabel, (Datatype)literal.datatype());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (aLabel.contains(",") || aLabel.contains("\r") || aLabel.contains("\n") || aLabel.contains("\"")) {
            quoted = true;
            aLabel = aLabel.replaceAll("\"", "\"\"");
        }
        StringBuilder aBuilder = new StringBuilder();
        if (quoted) {
            aBuilder.append("\"");
        }
        aBuilder.append(aLabel);
        if (quoted) {
            aBuilder.append("\"");
        }
        return aBuilder.toString();
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) throws ResultWritingFailed {
    }

    public void end() {
        try {
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public static final class CSVRWFactory
    implements QueryResultWriterFactory {
        @Nonnull
        public QueryResultFormat format() {
            return QueryResultFormats.CSV;
        }

        @Nonnull
        public QueryResultWriter create(@Nonnull OutputStream theOutputStream, @Nonnull Options theOptions) {
            return new SPARQLCSVResultWriter(theOutputStream);
        }
    }
}

