/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.text.csv;

import com.complexible.common.base.Options;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.XMLDatatypes;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.SelectQueryResultParser;
import com.stardog.stark.vocabs.XSD;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class SPARQLCSVResultParser
implements SelectQueryResultParser {
    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.CSV;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull SelectQueryResultHandler theHandler, @Nonnull Options theOptions) throws IOException {
        try (CSVReader aReader = new CSVReaderBuilder((Reader)new InputStreamReader(theStream, this.format().charset())).withCSVParser((ICSVParser)new RFC4180Parser()).build();){
            String[] nextLine;
            theHandler.start();
            String[] aVars = aReader.readNext();
            theHandler.variables(Arrays.asList(aVars));
            while ((nextLine = aReader.readNext()) != null) {
                BindingSets.Builder aBuilder = BindingSets.builder();
                for (int i = 0; i < nextLine.length; ++i) {
                    String aStr = nextLine[i];
                    BNode aValue = null;
                    if (aStr.startsWith("_:")) {
                        aValue = Values.bnode((String)aStr.substring(2));
                    } else if (!"".equals(aStr)) {
                        if (aStr.matches("^[\\+\\-]?[\\d\\.].*")) {
                            IRI aDatatype = null;
                            if (XMLDatatypes.isValidInteger((String)aStr)) {
                                aDatatype = XMLDatatypes.isValidNegativeInteger((String)aStr) ? XSD.NEGATIVE_INTEGER : XSD.INTEGER;
                            } else if (XMLDatatypes.isValidDecimal((String)aStr)) {
                                aDatatype = XSD.DECIMAL;
                            } else if (XMLDatatypes.isValidDouble((String)aStr)) {
                                aDatatype = XSD.DOUBLE;
                            }
                            aValue = aDatatype != null ? Values.literal((String)aStr, (IRI)aDatatype) : Values.literal((String)aStr);
                        } else {
                            try {
                                aValue = Values.iri((String)aStr);
                            }
                            catch (IllegalArgumentException e) {
                                aValue = Values.literal((String)aStr);
                            }
                        }
                    }
                    aBuilder.add(aVars[i], (Value)aValue);
                }
                theHandler.handle((Object)aBuilder.build());
            }
            theHandler.end();
        }
    }
}

