/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.reasoning.client;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.impl.MemoryStatementSource;
import com.complexible.common.rdf.impl.StatementIterationInputStream;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.ConnectionConfiguration;
import com.complexible.stardog.api.reasoning.AbstractReasoningConnection;
import com.complexible.stardog.api.reasoning.ReasoningConnection;
import com.complexible.stardog.protocols.http.client.ApacheHttp;
import com.complexible.stardog.protocols.http.client.BaseHttpClient;
import com.complexible.stardog.protocols.http.client.Client;
import com.complexible.stardog.protocols.http.client.HttpClient;
import com.complexible.stardog.protocols.http.client.HttpConnection;
import com.complexible.stardog.reasoning.AbstractStardogExplainer;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofList;
import com.complexible.stardog.reasoning.ProofReader;
import com.complexible.stardog.reasoning.StardogExplainer;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.stardog.stark.Axiom;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.io.entity.EntityUtils;

final class HttpReasoningConnection
extends AbstractReasoningConnection
implements ReasoningConnection {
    private final String consistencyURI;
    private final String exportURI;
    private static final Gson mGson = new GsonBuilder().registerTypeAdapter(ProofList.class, (Object)new ProofReader()).setPrettyPrinting().create();

    public HttpReasoningConnection(HttpConnection theHttpConnection) {
        super((Connection)theHttpConnection);
        this.consistencyURI = theHttpConnection.getClient().url("reasoning/consistency");
        this.exportURI = theHttpConnection.getClient().url("reasoning/schema");
    }

    protected HttpConnection getConnection() {
        return (HttpConnection)super.getConnection();
    }

    public StardogExplainer explain(Axiom theExpr) {
        return new AbstractStardogExplainer<Axiom>(theExpr){

            protected Iterable<Proof> proofs(Axiom theExpr, Options theOptions) throws StardogException {
                return HttpReasoningConnection.this.executeExplain(HttpReasoningConnection.this.getConnection().getTxId(), theExpr, theOptions);
            }
        };
    }

    public boolean isConsistent(Collection<IRI> theActiveGraphs) throws StardogException {
        return this.executeConsistencyCheck(theActiveGraphs);
    }

    public void close() throws StardogException {
        super.close();
    }

    public Iterable<Statement> exportSchema() throws StardogException {
        Set set;
        ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
        aBuilder.parameter("schema", this.getSchema());
        HttpGet get = new HttpGet(aBuilder.uri(this.exportURI));
        RDFFormat format = RDFFormats.TURTLE;
        ApacheHttp.HttpRequests.accept((HttpMessage)get, (String)format.defaultMimeType());
        CloseableHttpResponse response = null;
        try {
            response = this.getConnection().getClient().execute((ClassicHttpRequest)get);
            InputStream stream = response.getEntity().getContent();
            set = RDFParsers.read((InputStream)stream, (RDFFormat)format);
        }
        catch (Exception e) {
            try {
                Throwables.propagateIfInstanceOf((Throwable)e, StardogException.class);
                throw new StardogException((Throwable)e);
            }
            catch (Throwable throwable) {
                ApacheHttp.HttpResponses.consumeQuietly(response);
                throw throwable;
            }
        }
        ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)response);
        return set;
    }

    public boolean executeConsistencyCheck(Collection<IRI> theActiveGraphs) throws StardogException {
        ApacheHttp.Parameters.ParameterListBuilder aBuilder = ApacheHttp.Parameters.builder();
        for (IRI aActiveGraph : theActiveGraphs) {
            aBuilder.parameter("graph-uri", aActiveGraph.toString());
        }
        aBuilder.parameter("schema", this.getSchema());
        HttpGet get = new HttpGet(aBuilder.uri(this.consistencyURI));
        try {
            return ApacheHttp.HttpResponses.toBoolean((CloseableHttpResponse)this.getConnection().getClient().execute((ClassicHttpRequest)get));
        }
        catch (Exception e) {
            throw Client.toStardogException((String)"Error getting content in response to consistency check", (Exception)e);
        }
    }

    private Iterable<Proof> executeExplain(UUID theTxId, Axiom theExpr, Options theOptions) throws StardogException {
        boolean aInconsistency = theExpr == StardogExplainer.INCONSISTENCY;
        StringBuilder uri = new StringBuilder();
        if (theTxId != null) {
            uri.append(theTxId).append("/");
        }
        uri.append("reasoning").append("/").append("explain");
        if (aInconsistency) {
            uri.append("/").append("inconsistency");
        }
        HttpPost aRequest = new HttpPost(this.getConnection().getClient().url(uri.toString()));
        aRequest.addHeader(HttpClient.ACCEPT_JSON_HEADER);
        theOptions.set(ConnectionConfiguration.REASONING_SCHEMA, (Object)this.getSchema());
        try {
            BaseHttpClient.addConnectionStringParams((HttpMessage)aRequest, (Options)theOptions);
            if (!aInconsistency) {
                aRequest.setEntity(ApacheHttp.Entities.create((InputStream)new StatementIterationInputStream(new MemoryStatementSource((Iterable)Sets.newHashSet((Iterable)theExpr)).statements(), RDFFormats.TURTLE), (ContentType)ContentType.create((String)RDFFormats.TURTLE.defaultMimeType())));
            }
            Iterable<Proof> iterable = this.getExplainResult(this.getConnection().getClient().execute((ClassicHttpRequest)aRequest));
            return iterable;
        }
        catch (URISyntaxException e) {
            throw new StardogException((Throwable)e);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)aRequest.getEntity());
        }
    }

    private Iterable<Proof> getExplainResult(CloseableHttpResponse aResponse) throws StardogException {
        HttpEntity aEntity = aResponse.getEntity();
        if (aEntity == null) {
            throw new StardogException("Empty response to explain inference");
        }
        try {
            Iterable<Proof> aProofs;
            try (InputStream content = aEntity.getContent();){
                aProofs = this.toProof(content);
            }
            Iterable<Proof> iterable = aProofs;
            return iterable;
        }
        catch (IOException e) {
            throw new StardogException("Error getting content in response to inference explanation.", (Throwable)e);
        }
        finally {
            ApacheHttp.HttpResponses.consumeQuietly((CloseableHttpResponse)aResponse);
        }
    }

    private Iterable<Proof> toProof(InputStream theInputStream) throws StardogException {
        try {
            JsonReader aJsonReader = new JsonReader((Reader)new InputStreamReader(theInputStream, "UTF-8"));
            return (Iterable)mGson.fromJson(aJsonReader, ProofList.class);
        }
        catch (Exception e) {
            throw new StardogException("Error getting content in response to inference explanation", (Throwable)e);
        }
    }
}

