/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.dataexporter.output.wiki;

import com.brsanthu.dataexporter.AbstractDataWriter;
import com.brsanthu.dataexporter.ExportOptions;
import com.brsanthu.dataexporter.model.CellDetails;
import com.brsanthu.dataexporter.model.HeaderCellDetails;
import com.brsanthu.dataexporter.model.RowDetails;
import com.brsanthu.dataexporter.model.Table;
import com.brsanthu.dataexporter.output.wiki.WikiExportOptions;
import java.io.OutputStream;
import java.io.Writer;

public class WikiWriter
extends AbstractDataWriter {
    public WikiWriter() {
        this(System.out);
    }

    public WikiWriter(WikiExportOptions options) {
        super((ExportOptions)options, System.out);
    }

    public WikiWriter(WikiExportOptions options, OutputStream out) {
        super((ExportOptions)options, out);
    }

    public WikiWriter(OutputStream out) {
        super((ExportOptions)new WikiExportOptions(), out);
    }

    public WikiWriter(WikiExportOptions options, Writer out) {
        super((ExportOptions)options, out);
    }

    public WikiWriter(Writer out) {
        super((ExportOptions)new WikiExportOptions(), out);
    }

    public WikiExportOptions getTextExportOptions() {
        return (WikiExportOptions)this.getOptions();
    }

    @Override
    public void beforeHeaderRow(Table table) {
        this.println();
        this.print(this.getTextExportOptions().getDelimiter());
    }

    @Override
    public void writeHeaderCell(HeaderCellDetails headerCell) {
        this.writeCell(headerCell.getColumnIndex(), headerCell.getColumn().getTitle());
    }

    @Override
    public void afterHeaderRow(Table table) {
        this.print(this.getTextExportOptions().getDelimiter());
    }

    @Override
    public void beforeRow(RowDetails rowDetails) {
        this.println();
        this.print(this.getTextExportOptions().getDelimiter());
    }

    @Override
    public void writeRowCell(CellDetails cellDetails) {
        Object cellValue = cellDetails.getCellValue();
        this.writeCell(cellDetails.getColumnIndex(), cellValue == null ? "" : cellDetails.getColumn().format(cellDetails));
    }

    public void writeCell(int i, String cellValue) {
        String delimiter = this.getTextExportOptions().getDelimiter();
        if (i != 0) {
            this.print(delimiter);
        }
        this.print(cellValue);
    }

    @Override
    public void afterRow(RowDetails rowDetails) {
        this.print(this.getTextExportOptions().getDelimiter());
    }
}

